/***************************************************************************/
/* ViewBitmap.h - interface file for ViewBitmap class			   */
/* January 1990   Carl F. Sutter					   */
/***************************************************************************/

#import <appkit/View.h>
#import <appkit/Bitmap.h>

@interface ViewBitmap:View
   {
   Bitmap	*bmpImage;	/* bitmap displayed in the window */
   NXSize	nxsBitmap;	/* size of bitmap being displayed */
   NXPoint	nxpTopLeft;	/* top left corner of window */
   char		szTitle[160];	/* window title */
   id		closeNotify;	/* object to notify if the window is closed */
   }

/* factory methods */
+ newBitmap:(Bitmap *)bmpIn;
+ newBitmap:(Bitmap *)bmpIn title:(char *)szTitleIn;
+ newBitmap:(Bitmap *)bmpIn title:(char *)szTitleIn topLeft:(NXPoint)nxpTopLeftIn;

/* this view's window delegate methods sent to this view to handle */
- windowWillResize:sender toSize:(NXSize *)frameSize;
- windowWillClose:sender;

// methods that can be called from the controlling object
- setMiniwindowIcon:(const char *)anIcon;
- (BOOL)saveBitmapToTiff:(const char *)fileName;
- setCloseNotify:notify;

/* internal methods */     
- setup;
- drawSelf:(NXRect *)r :(int) count;
- errorAlert:(char *)szMessage;

@end
