/*
 * sampling.c
 *
 * Copyright (C) 1989, 1991, Craig E. Kolb, Rod G. Bogart
 * All rights reserved.
 *
 * This software may be freely copied, modified, and redistributed
 * provided that this copyright notice is preserved on all copies.
 *
 * You may not distribute this software, in whole or in part, as part of
 * any commercial product without the express consent of the authors.
 *
 * There is no warranty or other guarantee of fitness of this software
 * for any purpose.  It is provided solely "as is".
 *
 * $Id$
 *
 * $Log$
 */
#include "common.h"
#include "sampling.h"

SampleInfo	Sampling;	/* sampling information */

/*
 * Set sampling options.
 * Current limited to sqrt of # samples/pixel.
 */
void
SamplingSetOptions(n)
int n;
{
	Sampling.sidesamples = n;
	Sampling.totsamples = n*n;
	Sampling.weight = 1. / (Float)Sampling.totsamples;
	Sampling.spacing = 1. / (Float)Sampling.sidesamples;
}

/*
 * Find a point on a unit circle that is separated from other random
 * points by some jitter spacing.
 *
 * It should do the above, but the temporary hack below just finds a
 * jittered point in a unit square.
 */
void
UnitCirclePoint(pnt, sample)
Vector *pnt;
{
	/*
	 * This picks a random point on a -1 to 1 square.  The jitter stuff
	 * is correct enough to avoid excessive noise.  An extremely blurry
	 * bright highlight will look squarish, not roundish.  Sorry.
	 */
	Float jit;

	if (sample >= 0) {
		jit = 2. * Sampling.spacing;

		pnt->x = nrand()*jit - 1.0 +
			(sample % Sampling.totsamples) * jit;
		pnt->y = nrand()*jit - 1.0 +
			(sample / Sampling.totsamples) * jit;
		pnt->z = 0.0;
	} else {
		pnt->x = nrand() * 2.0 - 1.0;
		pnt->y = nrand() * 2.0 - 1.0;
		pnt->z = 0.0;
	}
}
