/*
 * main.c
 *
 * Copyright (C) 1989, 1991, Craig E. Kolb
 * All rights reserved.
 *
 * This software may be freely copied, modified, and redistributed
 * provided that this copyright notice is preserved on all copies.
 *
 * You may not distribute this software, in whole or in part, as part of
 * any commercial product without the express consent of the authors.
 *
 * There is no warranty or other guarantee of fitness of this software
 * for any purpose.  It is provided solely "as is".
 *
 * $Id$
 *
 * $Log$
 */

char rcsid[] = "version 4.0 Beta";

#include "rayshade.h"
#include "options.h"
#include "stats.h"
#include "viewing.h"
#include "picture.h"

int
main(argc, argv)
int argc;
char **argv;
{
	Float utime, stime;

	extern void setup(), cleanup(), viewing(), raytrace();
	extern void VersionPrint();

	/*
 	 * Initialize variables, etc.
	 */
	setup();
	/*
	 * Parse options from command line.
	 */
	OptionsSet(argc, argv);
	/*
	 * Process input file.
	 */
	if (Options.verbose) {
		VersionPrint();
		fprintf(Stats.fstats,"Reading input file...\n");
		(void)fflush(Stats.fstats);
	}
	read_input_file();
	/*
	 * Set variables that weren't set on command line
	 * or in input file.
	 */
	cleanup();

	/*
	 * Set up viewing parameters.
	 */
	viewing();

	/*
 	 * Print more information than we'll ever need to know...
	 */
	if (Options.verbose) {
		extern Object *World;
		/* World object info. */
		AggregatePrintInfo(World, Stats.fstats);
		/* Print info about rendering options and the like. */
		OptionsList();
	}
	/*
	 * Start new picture.
	 */
	PictureStart(argv);

	/*
	 * Print preprocessing time.
	 */
	get_cpu_time(&utime, &stime);
	fprintf(Stats.fstats,"Preprocessing time:\t");
	fprintf(Stats.fstats,"%2.2fu  %2.2fs\n", utime, stime);
	fprintf(Stats.fstats,"Starting trace.\n");
	(void)fflush(Stats.fstats);
	/*
	 * Trace the image.
	 */
	raytrace();
	/*
	 * Close the image file.
	 */
	PictureEnd();
	StatsPrint();
	return 0;
}
