;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;
;;; Prolog:  top-level file, which loads the rest of the system.
;;;          Interval arithmetic can be disabled.
;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

(define debug? #f)
(define user-debug? #f)
(define (user-debug arg)
	(if	user-debug?
		(begin	(display arg)
			(newline))))

(load "compatibility.ss")
(load "tables.ss")
(load "clauses.ss")
(load "predicates.ss")
(load "goals.ss")
(load "dlists.ss")
(load "programs.ss")
(load "compile.ss")
(load "terms.ss")
(load "search.ss")
(load "flounder.ss")

;; To disable interval arithmetic, set intervals? to #f and comment out
;; the load line for interval.ss.
(define intervals? #t)
(load "interval.ss")

(define (pro . file-name-list)
    (begin
      (newline)
      (display "A Prolog goal is an unquoted LIST of predicate calls.")
      (newline)
      (display "To toggle predicate tracing, type as a Prolog goal: ((debug))")
      (newline)
      (if intervals?
	  (eval (append '(prolog "builtin.pro" "interval.pro") file-name-list))
	  (eval (append '(prolog "builtin.pro") file-name-list))
      )
    )
)

(define (greetings)
  (display "To start the Prolog interpreter, type:  (pro <file-names>...)")
  (newline)
)

(greetings)
