#import "DirPanel.h"

#import <appkit/Button.h>
#import <appkit/Form.h>
#import <appkit/NXBrowser.h>
#import <appkit/appkit.h>
#import <string.h>

const char *dirOnlyType[] = { "...ABDCEFGHIJKLMNOPQRSTUVWXYZ",NULL};

@implementation DirPanel

/* Overriden new method to set permanately enable the Ok button */
+ new
{
	self = [super new];
	[okButton setEnabled: YES];
	okButton = nil;
	/* Set the Home button's action to my goHome: method */
	[_homeButton setAction: @selector(goHome:)];
	/* Set the browser action so that the selected path is displayed in the form */
	[browser setAction: @selector(showSelectionPath)];
	/* Allow a double click to select the item */
	[browser setDoubleAction: @selector(doubleClick)];
	/* Typing return in the form activates the ok: method */
	[form setAction: @selector(ok:)];

	return self;
}

- goHome: sender
{
	strcpy(directoryName,NXHomeDirectory());
	[browser setPath : directoryName];
	[form setStringValue : directoryName at : 0];
	return self;
}

/* Overriden ok: method to determine the directory name */
- ok: sender
{
	[self showSelectionPath];
fprintf(stderr,"Dir = %s\n",directoryName);
	[NXApp stopModal: 1];

	return self;
}

- doubleClick
{
	return [self ok: self];
}

- showSelectionPath
{
int column;
id matrix;
char path[MAXPATHLEN];

	column = [browser selectedColumn];
	[browser getPath : path toColumn : column];
	matrix = [browser matrixInColumn : column];
	sprintf(directoryName,"%s/%s",path,[[matrix selectedCell] stringValue]);
	[form setStringValue: [[matrix selectedCell] stringValue] at: 0];
	return self;
}

/* Overriden directory method returns directoryName */
- (const char *) directory;
{
	return (const char *) directoryName;
}

/* The runModalForDirectory:file: method.  This the how the panel
	should be activated */
- (int) runModalForDirectory: (const char *) dirName file:(const char *) fileName
{
	return [super runModalForDirectory: dirName file: fileName types: dirOnlyType];
}

#ifdef FILE_COMPLETION
static char completedPath[MAXPATHLEN],*completionName;

- textDidGetKeys: sender isEmpty: (BOOL)flag
{
char name[32],*cellName;
int count;
fprintf(stderr,"length = %d\n",[sender getSubstring: name start: 0 length: 128]);
	sprintf(completedPath,"%s/%s",directoryName,name);
fprintf(stderr,"partial = %s\n", completedPath);
	count = NXCompleteFilename(completedPath, MAXPATHLEN);
	cellName = strrchr(completedPath,'/');
	if(count == 0 || flag == YES)
	{
		completionName = NULL;
		return self;
	}
	completionName = ++cellName;
fprintf(stderr,"textDidGetKeys: partial = %s; count = %d", completedPath,count);
	if(cellName[1] != '\0' && count > 0)
		[browser setPath: completedPath];
	return self;
}
#endif

@end
/* RCS Information:
	$Author: me $;
	$Date: 92/05/03 17:25:02 $;
	$Source: /RS6000/usr/local/NFS_NeXT/Dev/Net/Archie_Prospero/Archie/RCS/DirPanel.m,v $;
	$Revision: 1.4 $;
*/
