#import <PercentView.h>
#import <dpsclient/dpsclient.h>
#import <dpsclient/wraps.h>
#import <appkit/nextstd.h>
#import <appkit/graphics.h>

@implementation PercentView

- displayPercent: (float) p
{
	percent = p;
	[self display];
	return self;
}

- drawSelf: (const NXRect *) rects :(int) rectCount
{
float x,y,dx,dy;
float r,endAngle;

	if(rectCount == 0)
		return self;

	/* Calculate my center, radius, and end angle */
	dx = bounds.size.width / 2.0;
	x =  dx + bounds.origin.x;
	dy = bounds.size.height / 2.0;
	y = dy + bounds.origin.y;
	r = MIN(dx,dy);
	r -= 2;
	endAngle = 90.0 - 360.0 * percent;

	/* Erase my bounds */
	PSsetgray(NX_LTGRAY);
	NXRectFill(&bounds);

	/* Draw black circle for the dial */
	PSsetgray(NX_BLACK);
	PSarc(x, y, r, 0.0, 360.0);
	PSstroke();
	/* Draw the pie slice */
	PSmoveto(x, y);
	PSarcn(x,y,r,90.0, endAngle);
	PSclosepath();
	PSgsave();
		PSsetgray(NX_DKGRAY);
		PSfill();
	PSgrestore();
	PSstroke();

	[super drawSelf: rects : rectCount];
	return self;
}

@end
/* RCS Information:
	$Author: me $;
	$Date: 92/05/03 17:39:10 $;
	$Source: /RS6000/usr/local/NFS_NeXT/Dev/Net/Archie_Prospero/Archie/RCS/PercentView.m,v $;
	$Revision: 1.5 $;
*/
