
/* ---------------------------------------- */
/* FrontEnd.m -- Copyright (c) 1990 Ed Hill */
/* ---------------------------------------- */

#import <objc/Object.h>

@interface FrontEnd:Object
{
    id 		FrontEndWindow;		/* Program display window			*/
    id 		IconBox;		/* Box were Mac icon is displayed		*/
    id 		IconBox2;		/* Box were NeXT icon is displayed		*/
    id		NameView;		/* Textfield were Mac file name is displayed	*/
    id		NameView2;		/* Textfield were NeXT file name is displayed	*/
    id		SampleButton;		/* Button that represents the PopUpList		*/
    id		ConvertButton;		/* Button that starts the Converting process	*/
    id		ErrorText;		/* Text that shows any Errors			*/
    id		currentSound;		/* The current NeXT sound			*/
    id		myGNULicense;		/* GNU Liscense display			       	*/
    id 		popup;			/* Actual PopUpList that shows Sampling Rates  	*/
    char	*macSoundName;		/* The current path list of the Mac sound      	*/
    char	*nextSoundName;		/* The current path list of the NeXT sound     	*/
    char	*iconPath;		/* The path of the file that has been selected 	*/
    BOOL	isPaused;		/* Current status of the sound (ON/OFF)	       	*/
    BOOL	NothingHere;		/* Tells there's a file that needs converting  	*/
    int		sampleRate;		/* Current Sampling Rate (1=22 KHz, 0=11 KHz)  	*/
}

/* Set up any visual objects through the Interface Builder 		   	       	*/
-setFrontEndWindow:anObject;
-setNameView:anObject;
-setNameView2:anObject;
-setIconBox:anObject;
-setIconBox2:anObject;
-setSampleButton:anObject;
-setConvertButton:anObject;
-setErrorText:anObject;

/* Interacting with the WorkSpace Manager 		   		   	       	*/
-setUpDraggedInFiles:sender;

/* Manipulating the converted sound so the user can verify the conversion  	       	*/
-playsound:sender;
-stopsound:sender;
-pausesound:sender;

/* Internal methods that handle converting the sound			   	       	*/
-changeSampleRate:sender;
-convertMactoNeXT:sender;
-_actualMactoNeXTcode:(int)sampleRate;

/* Public method that shows the GNU Public License			   	       	*/
-showGNULicense:sender;

@end
