//
//	HenonView:View
//
//	written by Anders Bertelrud
//	(c) 1990, 1991 by Anders Bertelrud
//


#import <appkit/View.h>


typedef	id	id0;		// id0's are id's that don't get parsed by IB


@interface HenonView:View
{
	// Outlets to views in the Hnon panel.
	id				orbitField;
	id				pointsField;
	id				incYField;
	id				incXField;
	id				startYField;
	id				startXField;
	id				phaseField;
	id				phaseSlider;
	id				currentOrbitField;
	id				nextOrbitButton;
	id				lField;
	id				tField;
	id				rField;
	id				bField;
	id				startStopButton;

	// Other outlets.
	id				stringTable;

	// Things to keep track of the timer.
	DPSTimedEntry	timer;
	BOOL			timerTicking;

	// Things controlling the mapping cache image.
	id0				henonCache;

	// Various flags. 
	BOOL			useGrid;
	BOOL			continuousPlot;
	BOOL			isRunning;

	// Input used in the Hnon mapping calculations.
	float			L, T, R, B, x0, y0, dx0, dy0, phase;
	int				orbits, points;

	// Other variables used in the Hnon mapping calculations.
	float			cosa, sina, xOld, yOld, xScale, yScale;
	int				currentOrbit, currentPoint;
}



////////////////////// Creation & Destruction Methods //////////////////////

- initFrame:(const NXRect *)f;
- free;


//////////////////////////// Rendering Methods /////////////////////////////

- drawSelf:(const NXRect *)rects :(int)rectCount;


/////////////////////////////// File Methods ///////////////////////////////

- saveAsTIFF:sender;


////////////////////////////// Action Methods //////////////////////////////

///// From buttons in the Hnon panel /////
- startStop:sender;
- gridChecked:sender;
- nextOrbit:sender;

///// From menu items /////
- setPlotValues1:sender;
- setPlotValues2:sender;
- setPlotValues3:sender;


////////////////////////////// Timer Methods ///////////////////////////////

- startTimer;
- stopTimer;


////////////////////////// Miscellaneous Methods ///////////////////////////

- initHenonCache;
- doHenonCalculation;


//////////////////////////// Delegation Methods ////////////////////////////

- appDidInit:sender;


@end