
/* Generated by Interface Builder */

extern void energy();


#import "SoundEditor.h"

#import <appkit/View.h>
#import <appkit/appkit.h>
#import <soundkit/soundkit.h>
#import <strings.h>

@implementation SoundEditor

static newLocation(NXPoint *p)
{
    // compute the location of the new window
    // shifted to the botom-right
    static count = 0;
    p->x += (20.0 * count);
    p->y -= (25.0 * count);
    count = (count > 10)? 0 : count+1;
}


+new
{
  // create the new window
  // and initialize the different parameters
  self = [super new];
  [NXApp loadNibSection:"SoundEditor.nib" owner:self];

  // browser purpose
  strcpy(SignalFileName,"SoundEditor.snd");
  strcpy(SignalDirName,".");
  strcpy(EnergyFileName,"E.SoundEditor.snd");
  strcpy(EnergyDirName,"./");

  // view attributes
  [SoundSignal setAutodisplay:YES];
  [SoundSignal setAutoscale:  YES];
  [SoundZoom   setAutodisplay:YES];
  [SoundZoom   setAutoscale:  YES];
  [SoundEnergy setAutodisplay:YES];
  [SoundEnergy setAutoscale:  YES];
  [SoundEnergy setEnabled:    NO ];
  [SoundEnergy setDisplayMode:SK_DISPLAY_WAVE];

  // view defaults contents
  sndSignal = [Sound new];
  [SoundSignal setSound:sndSignal];
  sndZoom = [Sound new];
  [SoundZoom setSound:sndZoom];
  sndEnergy = [Sound new];
  [SoundEnergy setSound:sndEnergy];

  return self;
}


- setSoundZoom:anObject
{
    SoundZoom = anObject;
    return self;
}

- setSoundEnergy:anObject
{
    SoundEnergy = anObject;
    return self;
}

- setSoundWindow:anObject
{
    NXRect theFrame;
    SoundWindow = anObject;
    [SoundWindow getFrame:&theFrame];
    newLocation(&theFrame.origin);
    [SoundWindow moveTo:theFrame.origin.x :theFrame.origin.y];
    return self;
}

- setSoundSignal:anObject
{
    SoundSignal = anObject;
    return self;
}

- PlayAllZoom:sender
{
    // play the whole zoom sound
    id ZoomSound;
    ZoomSound = [Sound new];
    ZoomSound = [SoundZoom sound];
    [ZoomSound play];
    return self;
}

- Play:sender
{
    // play the current selection of the signal sound
    [SoundSignal play:sender];
    return self;
}

- ZoomOut:sender
{
    // zoom out from zoom sound to signal sound
		[SoundZoom selectAll:sender];
		[SoundZoom      copy:sender];
		[SoundSignal   paste:sender];
    [self ComputeEnergy];
    return self;
}

- PlayZoom:sender
{
    // play the current selection of the zoom sound
    [SoundZoom play:sender];
    return self;
}

- Record:sender
{
    // record from the microphone to the selected part of the signal sound
    static int state=0;
    state = (++state)%2;
    if (state) {
      [SoundSignal record:sender];
      }
    else {
      [SoundSignal stop:sender];
      [self ComputeEnergy];
      }
    return self;
}

- PlayAll:sender
{
    // play the whole signal sound
    id SignalSound;
    SignalSound = [Sound new];
    SignalSound = [SoundSignal sound];
    [self ComputeEnergy];
    [SignalSound play];
    return self;
}

- Load:sender
{
    id   theBrowser;
    id   aSound;
    int  result;
    char *slashPtr;

    // open a browser and load the selected file
    theBrowser = [OpenPanel new];
    [theBrowser setRequiredFileType: "snd"];
    [theBrowser setDirectory: SignalDirName];

    result = [theBrowser runModal];
    if (result) {
      aSound = [Sound new];
      strcpy(SignalFileName,[theBrowser filename]);
      strcpy(SignalDirName,SignalFileName);
      slashPtr = rindex (SignalDirName, '/');
      if (slashPtr) {
        *slashPtr = '\0';
        }
      [aSound readSoundfile:SignalFileName];
      [SoundSignal setSound:aSound];
      strcpy(EnergyFileName,"E.");
      strcat(EnergyFileName,strrchr(SignalFileName,'/')+1);
      [SoundWindow setTitle:strrchr(SignalFileName,'/')+1];
      [self ComputeEnergy];
      }
    return self;
}

- ZoomIn:sender
{
    // zoom in from the signal sound to the zoom sound
    int firstSample, sampleCount;
    id aSound;
    aSound = [Sound new];
    [SoundSignal getSelection:&firstSample size:&sampleCount];
    [aSound copySound:[SoundSignal sound]];
    if (firstSample) {
      [aSound deleteSamplesAt:0 count:firstSample-1];
      }
    if (sampleCount) {
      [aSound deleteSamplesAt:sampleCount count:[aSound sampleCount]];
      }
    [SoundZoom setSound:aSound];
    return self;
}

- Show:sender
{
    [SoundWindow makeKeyAndOrderFront:self];
    return self;
}

- Save:sender
{
    id  theBrowser;
    id  aSound;
    int result;

    // open a browser and save the selected file
    theBrowser = [SavePanel new];
    [theBrowser setRequiredFileType: "snd"];
    result = [theBrowser runModalForDirectory: SignalDirName
                    file: SignalFileName];
    if (result) {
      aSound = [Sound new];
      aSound = [SoundSignal sound];
      sndSignal = [SoundSignal sound];
      strcpy(SignalFileName,[theBrowser filename]);
      [aSound writeSoundfile:SignalFileName];
      [SoundWindow setTitle:strrchr(SignalFileName,'/')+1];
      }
    return self;
}

- ComputeEnergy
{
    // compute the energy of the signal sound
    // and store it in the energy view
    char newEnergy[100];
    char SystemCommand[200];
    id aSound;
    aSound = [Sound new];

    if ([[SoundSignal sound] sampleCount]) {
      [[SoundSignal sound] writeSoundfile: EnergyFileName];
      energy (EnergyFileName);
      strcpy(newEnergy, EnergyFileName);
      strcat(newEnergy, ".energy");
      [aSound readSoundfile:newEnergy];
      [SoundEnergy setSound: aSound];

      // cleanup purpose
      strcpy(SystemCommand, "rm ");
      strcat(SystemCommand, EnergyFileName);
      system ( SystemCommand );
      strcpy(SystemCommand, "rm ");
      strcat(SystemCommand, newEnergy);
      system ( SystemCommand );
      }

    return self;

}


@end
