/*	Table for psencode to translate to/from system name encodings.
	This table is produced by executing the following code:

	/s (  ) def s 1 145 put
	0 1 255 {s exch 1 exch put s cvx exec =} for

	and then editing the output.  Zero pointers mean there is
	no system encoding for that number.
*/

const char * const systemnames[256] = {
	"abs",
	"add",
	"aload",
	"anchorsearch",
	"and",
	"arc",
	"arcn",
	"arct",
	"arcto",
	"array",
	"ashow",
	"astore",
	"awidthshow",
	"begin",
	"bind",
	"bitshift",
	"ceiling",
	"charpath",
	"clear",
	"cleartomark",
	"clip",
	"clippath",
	"closepath",
	"concat",
	"concatmatrix",
	"copy",
	"count",
	"counttomark",
	"currentcmykcolor",
	"currentdash",
	"currentdict",
	"currentfile",
	"currentfont",
	"currentgray",
	"currentgstate",
	"currenthsbcolor",
	"currentlinecap",
	"currentlinejoin",
	"currentlinewidth",
	"currentmatrix",
	"currentpoint",
	"currentrgbcolor",
	"currentshared",
	"curveto",
	"cvi",
	"cvlit",
	"cvn",
	"cvr",
	"cvrs",
	"cvs",
	"cvx",
	"def",
	"defineusername",
	"dict",
	"div",
	"dtransform",
	"dup",
	"end",
	"eoclip",
	"eofill",
	"eoviewclip",
	"eq",
	"exch",
	"exec",
	"exit",
	"file",
	"fill",
	"findfont",
	"flattenpath",
	"floor",
	"flush",
	"flushfile",
	"for",
	"forall",
	"ge",
	"get",
	"getinterval",
	"grestore",
	"gsave",
	"gstate",
	"gt",
	"identmatrix",
	"idiv",
	"idtransform",
	"if",
	"ifelse",
	"image",
	"imagemask",
	"index",
	"ineofill",
	"infill",
	"initviewclip",
	"inueofill",
	"inufill",
	"invertmatrix",
	"itransform",
	"known",
	"le",
	"length",
	"lineto",
	"load",
	"loop",
	"lt",
	"makefont",
	"matrix",
	"maxlength",
	"mod",
	"moveto",
	"mul",
	"ne",
	"neg",
	"newpath",
	"not",
	"null",
	"or",
	"pathbbox",
	"pathforall",
	"pop",
	"print",
	"printobject",
	"put",
	"putinterval",
	"rcurveto",
	"read",
	"readhexstring",
	"readline",
	"readstring",
	"rectclip",
	"rectfill",
	"rectstroke",
	"rectviewclip",
	"repeat",
	"restore",
	"rlineto",
	"rmoveto",
	"roll",
	"rotate",
	"round",
	"save",
	"scale",
	"scalefont",
	"search",
	"selectfont",
	"setbbox",
	"setcachedevice",
	"setcachedevice2",
	"setcharwidth",
	"setcmykcolor",
	"setdash",
	"setfont",
	"setgray",
	"setgstate",
	"sethsbcolor",
	"setlinecap",
	"setlinejoin",
	"setlinewidth",
	"setmatrix",
	"setrgbcolor",
	"setshared",
	"shareddict",
	"show",
	"showpage",
	"stop",
	"stopped",
	"store",
	"string",
	"stringwidth",
	"stroke",
	"strokepath",
	"sub",
	"systemdict",
	"token",
	"transform",
	"translate",
	"truncate",
	"type",
	"uappend",
	"ucache",
	"ueofill",
	"ufill",
	"undef",
	"upath",
	"userdict",
	"ustroke",
	"viewclip",
	"viewclippath",
	"where",
	"widthshow",
	"write",
	"writehexstring",
	"writeobject",
	"writestring",
	"wtranslation",
	"xor",
	"xshow",
	"xyshow",
	"yshow",
	"FontDirectory",  /* 197 */
	"SharedFontDirectory",
	"Courier",
	"Courier-Bold",
	"Courier-BoldOblique",
	"Courier-Oblique",
	"Helvetica",
	"Helvetica-Bold",
	"Helvetica-BoldOblique",
	"Helvetica-Oblique",
	"Symbol",
	"Times-Bold",
	"Times-BoldItalic",
	"Times-Italic",
	"Times-Roman",
	"execuserobject",
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0};

int systemindex(const char *n) {
    int t,b,c,i;
    t = 197; b = 0;
    while (t > b) {
	c = (t+b)/2;
	i = strcmp(n,systemnames[c]);
	if (!i) return(c);
	if (i < 0) t = c;
	else b = c+1;
	}
    for (c = 197; systemnames[c]; c++)
	if (!strcmp(n,systemnames[c])) return(c);
    return(-1);
    }
