
/* IconView.h */

#import <appkit/View.h>

@interface IconView:View
{
    id    bitmap, activeBitmap, windowList, upperRight, lowerRight;
    char  *appName;
    int   xGridLocation, yGridLocation, xMin, xMax, yMin, yMax, appsPSContext;
    BOOL  theDock, altDocAppHidden, highLighted, active;
}

/* factory methods */
+ new:(char *)name :icon :(int)xCoord :(int)yCoord;

/* class methods */
- initialize:list :(int)minX :(int)minY :(int)maxX :(int)maxY;
- createOrderedListForCorner:(int)corner;
- mouseDown:(NXEvent *)theEvent;
- handleNonDock:(NXEvent *)theEvent;
- drawSelf:(const NXRect *)rects :(int)rectCount;
- checkCoords:(float *)x :(float *)y;
- snapToGrid:(float *)x :(float *)y;
- moveWindows:(float)dx :(float)dy;
- (BOOL)theDock;
- hideOrUnhide;
- coordinates:(int *)xCoord :(int *)yCoord;

@end
