/*
 * Copyright 1990, John G. Myers
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 1, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#import "EtermApp.h"

@implementation EtermApp

- setEtermView:(id)anObject
{
    etermView = anObject;
    return self;
}

/*
 * We're ready to start.  Size the window apropriately and fire up the
 * emacs process, possibly editing a file.
 */
- appDidInit:(id)sender
{
	NXRect frameRect;
	int x, y;
	int rows, columns;

	x = atoi(NXGetDefaultValue("Emacs", "WinLocX"));
	y = atoi(NXGetDefaultValue("Emacs", "WinLocY"));
	rows = atoi(NXGetDefaultValue("Emacs", "Rows"));
	columns = atoi(NXGetDefaultValue("Emacs", "Columns"));
	[[etermView window] moveTo: (NXCoord)x: (NXCoord)y];
	[etermView sizeWindowTo: columns: rows];
	[[etermView window] getFrame : &frameRect];
	if ((frameRect.origin.y + frameRect.size.height) > screenSize.height)
	{
		frameRect.origin.y = screenSize.height - frameRect.size.height;
		[[etermView window] placeWindow: &frameRect];
	}
	[etermView startEmacs: fileToEdit];
/*	[[etermView window] display];	*/
	return self;
}

  
/*
 * Stash the name of a file in an instance variable so we
 * can give it to the child emacs when we fire it up.
 *
 * TODO: Later versions may want to send an "(event-open "foo")"
 * message if the child emacs is already started.  So far, I
 * haven't found out how to get Emacs to get open requests for
 * text files, yet get Edit to eat RTF files.  Also, it's not clear
 * whether all (or most) users of Emacs will want it to replace
 * Edit that way.
 *
 * We should probably also handle multiple appOpenFile:type: messages
 * before the appDidInit: message.
 */
- (int)appOpenFile:(const char *)path type:(const char *)type
{
    if (fileToEdit) return NO;

    fileToEdit = malloc(strlen(path)+1);
    strcpy(fileToEdit, path);
    return YES;
}

@end






