/*
 * Copyright 1990, John G. Myers
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 1, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#import <stdio.h>
#import <appkit/View.h>
#import <appkit/Font.h>

#define BORDER_WIDTH 2

@interface EtermView : View
{
    Font *displayFont;		/* Font to display with */
    int fontHeight, fontWidth, fontDescender; /* Font characteristics */
    float ffontHeight, ffontWidth;
    int lines, cols;		/* Size of view in characters */
    int masterChannel;		/* FD of /dev/pty device */
    int eventServerSocket;	/* FD listening for event connection */
    FILE *eventChannel;		/* file ptr of event socket */
}

+ initialize;
+ new;
- (FILE *)eventChannel;
- setEventChannel: (FILE *)fp;
- windowWillResize: sender toSize: (NXSize *)frameSize;
- windowDidResize: sender;
- sizeWindowTo: (int)newCols : (int)newLines;
- startEmacs: (char *)withFile;
- (BOOL)acceptsFirstResponder;
- keyDown: (NXEvent *)theEvent;
- mouseDown: (NXEvent *)theEvent;
- mouseUp: (NXEvent *)theEvent;
- rightMouseDown: (NXEvent *)theEvent;
- rightMouseUp: (NXEvent *)theEvent;
- cut: sender;
- copy: sender;
- paste: sender;
- undo: sender;
/*  - powerOff:*/
- getDimensions: (int *)linesPtr : (int *) colsPtr;
- (Font *)getDisplayFont:
	(float *) heightPtr :
	(float *) widthPtr :
	(int *) descenderPtr;
@end
