/* Program:	LogoutHook - MOTD compatible Workspace 'LogoutHook'
 *
 * Author:	Christopher Lane
 *		Symbolic Systems Resources Group
 *		Knowledge Systems Laboratory
 *		Stanford University
 *
 * Date:	8 March 1990
 *
 * Copyright:   1989, 1990 by The Leland Stanford Junior University.  May
 *              be distributed without restriction for non-commercial use.
 */
 
#include <c.h>
#include <stdio.h>
#include <stdlib.h>
#include <strings.h>
#include <utmp.h>
#include <sys/time.h>

#define WTMPFILE "/usr/adm/wtmp"
#define TTYDEVICE "console" /* basename(ttyname(0)) doesn't work in LogoutHook */

/* extern char *basename(char *); */ /* #include <text/pathutil.h> causes warnings */
/* extern char *ttyname(int); */

void main(int argc, char *argv[])
{
	FILE *f_utmp;
	struct timeval tp;
	struct utmp s_utmp;
    
	if ((f_utmp = fopen(WTMPFILE, "a")) != NULL) {
		if (gettimeofday(&tp, NULL) != CERROR) {
			s_utmp.ut_time = tp.tv_sec;
			(void) strncpy(s_utmp.ut_name, "", sizeof(s_utmp.ut_name));
 			(void) strncpy(s_utmp.ut_line, TTYDEVICE, sizeof(s_utmp.ut_line));
			(void) strncpy(s_utmp.ut_host, "", sizeof(s_utmp.ut_host));
			(void) fwrite(&s_utmp, sizeof(s_utmp), 1, f_utmp);
			}
		(void) fclose(f_utmp);
		}

	exit(EXIT_SUCCESS);
}
