/* Program:
 *
 *		MOTD - 'Motto of the day' window
 *
 * Author:
 *
 *		Christopher Lane (lane@sumex-aim.stanford.edu)
 *		Symbolic Systems Resources Group
 *		Knowledge Systems Laboratory
 *		Stanford University
 *
 * Contributors:
 *
 *		Izumi Ohzawa (izumi@violet.berkeley.edu)
 *		Group in Neurobiology/School of Optometry
 *		University of California, Berkeley
 *
 *		Steve Hayman (sahayman@cs.indiana.edu)
 *		Computer Science Department Workstation Manager
 *
 * Date:
 *
 *		16 April 1991
 *
 * Copyright:
 *
 *		1989, 1990 & 1991 by The Leland Stanford Junior University.
 *      May be distributed without restriction for non-commercial use.
 *
 */

#import <c.h>
#import <libc.h>
#import <stdlib.h>
#import <stdio.h>
#import <strings.h>

#import <pwd.h>
#import <utmp.h>
#import <lastlog.h>

#import <sys/file.h>
#import <sys/types.h>
#import <sys/stat.h>
#import <sys/param.h>

#import <streams/streams.h>
#import <appkit/appkit.h>
#import <appkit/defaults.h>
#import <appkit/Application.h>
#import <dpsclient/dpsclient.h>
#import <sound/sound.h>

#define APPLICATION		"MOTD"
#define SYSTEM			"System"
#define WTMPFILE		"/usr/adm/wtmp"
#define LASTLOGFILE		"/usr/adm/lastlog"
#define MOTDFILE		"/etc/motd"
#define MAILDIR			"/usr/spool/mail/"
#define SOUNDDIR		"/LocalLibrary/Sounds/"
#define MAILSND			"mail.snd"
#define NEWMAILSND		"newmail.snd"
#define MAILMESSAGE		"You have mail."
#define NEWMAILMESSAGE	"You have new mail."
#define FTPPREFIX		"ftp"
#define TTYDEVICE		"console" /* basename(ttyname(0)) doesn't work in LoginHook */

#define SECOND ((double) 1.0)
#define getDefault(s) NXGetDefaultValue(APPLICATION, s)
#define getSystemDefault(s) NXGetDefaultValue(SYSTEM, s)

extern uid_t getuid();

typedef enum { NONE, OLD, NEW } MailLevel;
typedef enum { LT = -1, EQ, GT } Comparison;

@interface MOTD:Application
{
	id	myWindow, myText, holdButton, cancelButton;
	id  mailPanel, mailText;
	MailLevel maillevel;
	DPSTimedEntry timedEntry;
	BOOL do_motd, hold, loginHook;
	const char *file, *name;
	int wait, uid;
}

+ initialize;
+ new;

- appDidInit:sender;
- windowWillClose:sender;
- free;

- setMyWindow:anObject;
- setMyText:anObject;

- setMailPanel:anObject;
- setMailText:anObject;

- getHoldButton;
- setHoldButton:anObject;

- getCancelButton;
- setCancelButton:anObject;

- (const char *) getUserName;
- setUserName:(const char *) pw_name;

- (int) getUID;
- setUID:(int) pw_uid;

- setDo_Motd:(BOOL) aBoolean;
- (BOOL) getDo_Motd;

- setMailLevel:(MailLevel) aMailLevel;
- (MailLevel) getMailLevel;

- (const char *) getFile;
- setFile:(const char *) aString;

- (BOOL) getHold;
- setHold:(BOOL) aBoolean;
- toggleHold:anObject;

- (BOOL) getLoginHook;
- setLoginHook:(BOOL) aBoolean;

- (int) getWait;
- setWait:(int) anInteger;

- (void) cancelLogin:anObject;

@end