/*
 *	$Id: window-position.c,v 1.5 89/11/28 16:01:02 gregc Exp $
 *
 *	Copyright 1989 by the Regents of the University of California and
 *	the UCSF Computer Graphics Laboratory.  All rights reserved.
 *	Freely redistributable.
 *
 *	window-position:  by Greg Couch, gregc@cgl.ucsf.edu, July 1989.
 *
 *		Generate random window postions.
 */

# include	<stdio.h>
# include	<stdlib.h>
# include	<string.h>
# include	<nextdev/video.h>

extern	int	getpid(void);
extern	int	getopt(int, char **, char *), optind;
extern	char	*optarg;

int
main(argc, argv)
	int	argc;
	char	*argv[];
{
	int	c;
	int	along_line;
	int	h, v;
	double	t;
	int	lowerX, upperX, lowerY, upperY;
	char	*invoked_as;

	if (argc <= 0) {
		invoked_as = "???";
		goto usage;
	}

	if ((invoked_as = strrchr(argv[0], '/')) != NULL)
		invoked_as += 1;
	else
		invoked_as = argv[0];

	along_line = 0;
	while ((c = getopt(argc, argv, "l")) != EOF) switch (c) {

	case 'l':
		along_line = 1;
		break;

	default:
		goto usage;
	}

	if (optind + 4 != argc) {
usage:
		(void) fprintf(stderr,
				"usage: %s [-l] lowerX upperX lowerY upperY\n",
				invoked_as);
		return 1;
	}

	lowerX = atoi(argv[optind + 0]);
	upperX = atoi(argv[optind + 1]);
	lowerY = atoi(argv[optind + 2]);
	upperY = atoi(argv[optind + 3]);

	if (lowerX < 0 || lowerX > VIDEO_W
	|| upperX < 0 || upperX > VIDEO_W
	|| lowerY < 0 || lowerY > VIDEO_H
	|| upperY < 0 || upperY > VIDEO_H) {
		(void) fprintf(stderr,
			"%s: bounds must be between (0, 0) and (%d, %d)\n",
			invoked_as, VIDEO_W, VIDEO_H);
		return 1;
	}

	srand(getpid());
	t = rand() / (double) RAND_MAX;
	h = lowerX + t * (upperX - lowerX) + .5;
	if (!along_line)
		t = rand() / (double) RAND_MAX;
	v = lowerY + t * (upperY - lowerY) + .5;
	printf("-WinLocX %d -WinLocY %d\n", h, v);
	return 0;
}
