	/*
	  Copyright (c) 1990, Scott Hess.  No rights reserved.  No
	  warrenty is provided for this software, neither explicit
	  nor implied.  The source and object code for this file
	  may be used and modified as the user sees fit.
	*/

#import <appkit/Speaker.h>

typedef struct _StuartDefault {
  const char *defName, *defValue;
} StuartDefault;

@interface StuartSpeaker : Speaker
{
  int nDefaults;		// The number of defaults.
  StuartDefault *defaults;	// defaults/values for the new Stuart.
  
  BOOL activate;		// activate Stuart when we call?
  char *host;			// host to run on.
}

	/*
	  These are for setting up the Speaker, initializing the
	  local variables.
	*/
+ new;
- free;

	/*
	  These are my primitive functions.  Don't use them, I'd
	  say.
	*/
-(int)_stuartNew:(char *)defs activate:(int)flag;
-(int)_stuartGet:(char **)defs;

	/*
	  These are for setting and getting the default values from
	  the local storage.
	*/
-(const char *)default:(const char *)name;
-(int)defaultAsInt:(const char *)name;
-(float)defaultAsFloat:(const char *)name;
-(BOOL)defaultAsBOOL:(const char *)name;
- default:(const char *)name as:(const char *)value;
- default:(const char *)name asInt:(int)value;
- default:(const char *)name asFloat:(float)value;
- default:(const char *)name asBOOL:(BOOL)value;

	/*
	  These communicate with Stuart.
	*/
-(int)stuartNew;
-(int)stuartGet;
-(int)stuartSend:(int)fd;
-(int)stuartConnectAndNew;
-(int)stuartConnectAndGet;
-(int)stuartConnectAndSend:(int)fd;

	/*
	  misc.
	*/
-(BOOL)activate;
- setActivate:(BOOL)flag;
-(const char *)host;
- setHost:(const char *)host;

@end

