/* File: SoundAndLight.h - Set screen brightness and speaker volume on login.
 *
 * By: Christopher Lane
 * Symbolic Systems Resources Group
 * Knowledge Systems Laboratory
 * Stanford University
 *
 * Date: 15 January 1991
 *
 * Copyright: 1989, 1990 & 1991 by The Leland Stanford Junior University.
 * This program may be distributed without restriction for non-commercial use.
 */

#import <c.h>
#import <stdio.h>
#import <stdlib.h>
#import <strings.h>
#import <sys/file.h>
#import <sys/ioctl.h>

#import <nextdev/video.h>
#import <sound/sound.h>

#import <appkit/appkit.h>
#import <appkit/defaults.h>
#import <appkit/Application.h>

#define APPLICATION "SoundAndLight"
#define DEVICE "/dev/vid0"

#define LEFTVOLUME "43"
#define RIGHTVOLUME "43"
#define BRIGHTNESS "63"
#define MUTE "No"

@interface SoundAndLight:Application { }

+ initialize;

- run;

- setBrightness:(int) value;
- setVolume:(int) lchan :(int) rchan;
- setMute:(BOOL) state;

- (int) getIntDefault:(char *) string;
- (BOOL) getBoolDefault:(char *) string;

- (void) unix_error:(char *) string;
- (void) sound_error:(char *) string errno:(int) error;

@end
