#import "PerspMat.h"

@interface AzimuthMat : PerspMat
 /* A special class of perspective matrices where the viewpoint is */
 /* determined by an azimuth angle (theta), an elevation angle (phi), */
 /* and a distance to the viewpoint.  The limits are the ranges of the */
 /* three coordinates.  The resulting projected points are in the */
 /* range [-1,1] */
{
  float theta, c_theta, s_theta, phi, c_phi, s_phi, dist, limits[6];
  float to_theta_cache[16], to_phi_cache[16], to_dist_cache[16];
  BOOL  is_cached_to_theta, is_cached_to_phi, is_cached_to_dist;
}

/* Factory Methods */

+new;     // as identity matrix with limits of [0,1] for all coordinates
+newLimits:(float *)newlimits;

/* Public Methods */

-reset;
-setlimits:(float *)newlimits;
-setTheta:(float) radians;
-setPhi:(float) radians;
-setdist:(float) distance;
-setinvdist:(float) invdistance;
-(float)getTheta:sender;
-(float)getPhi:sender;
-(float)getdist:sender;

@end
