/*	Test program for talking to the Pasteboard server.
	Note that the _NXxxx routines are in libNeXT_s.a, and that this must be linked
	in.  These routines are produced by the "mig" Mach Interface Generator, and do
	msg_rpc calls to Mach to talk to the Pasteboard server.
	Those Idiots at Next have hard coded the words "version 46" into programs!  Oh well.

	In any case, this program prints out the current contents of the pasteboard.
	If you provide a command-line argument, it then "cuts" that into the pasteboard
	as ASCII text.
 */

#include "port.h"
#import <sys/port.h>
#import <sys/message.h>

int AppkitServerPort;

extern char *NXAsciiPboard;
extern char *_NXSmartPaste;
extern char *NXPostScriptPboard;
extern char *NXTIFFPboard;
extern char *NXRTFPboard;

main(int argc, char **argv)
{
	int n,r,changecount,typelength,length,numtypes;
	char *typebuf,*buf,*c,*d;
	extern int name_server_port,task_self_;

	r = netname_look_up(name_server_port,"",
					"NeXT Pasteboard Server, version 46",&AppkitServerPort);
	if (r) {printf("Can't connect to Pasteboard, %s\n",mach_error_string(r)); exit(1);}

/*	r = _NXGetSession(AppkitServerPort,&changecount);
	printf("ChangeCount is %d (return value %d)\n",changecount,r); */

	r = _NXGetTypes(AppkitServerPort,&typebuf,&typelength,&numtypes,&changecount);
	printf("%d types (%d chars), ChangeCount %d (return value %d)\n",
		  numtypes,typelength,changecount,r);
	for (c=typebuf,n=numtypes; n>0; n--) {
		r = _NXBlockingGetData(AppkitServerPort,c,changecount,&buf,&length,&changecount);
		printf("%s = \"",c,r);
		for (d = buf,r = length; r>0; d++,r--) {
			if (*d < ' ' && *d != NL) printf("<%x>",*(unsigned char *)d);
			else putchar(*d);
			}
		puts("\"");
		r = vm_deallocate(task_self_,buf,length);
		if (r) printf("Error freeing buf, %s\n",mach_error_string(r));
		while (*c++);
		}
	r = vm_deallocate(task_self_,typebuf,typelength);
	if (r) printf("Error freeing typebuf, %s\n",mach_error_string(r));

	if (argv[1]) {
		r = _NXSetTypes(AppkitServerPort,0,0,NXAsciiPboard,strlen(NXAsciiPboard)+1,1,&changecount);
		r = _NXSetData(AppkitServerPort,changecount,NXAsciiPboard,argv[1],strlen(argv[1]),&changecount);
		printf("New change count is %d, return is %d\n",changecount,r);
		}
	}
