/* VERSION.C -- File Version Number Update Program

	Updated January 1987 by Bill Spitzak

	A file is searched, and any strings of the following forms are
changed (N = digit, all others indicate lower or upper case letters):

	Version N.Nx			Version zzzz (where zzzz is given as arg 1)
	VN.Nx				Vzzzz (where zzzz is given as arg 1)
	dd-mmm-yy				Today's date

*/

#include "port.h"

#define BUFFSIZE	2048
char buf[BUFFSIZE*2+1];
flag bufmod;

main(argc,argv)
	int argc;
	char *argv[];
	{
	int fd,len;
	char *newversion, *fname;
	if (argc < 2 || argc > 3) {
		puts("Change version and dates in a program file:\n"
			"version {N.NN} filename\n");
		exit(1);
		}

	if (argc > 2) {newversion = argv[1]; fname = argv[2];}
	else {newversion = 0; fname = argv[1];}

	if (newversion) {
		if (strlen(newversion) != 4) {
			printf("Version number must be four characters long\n");
			exit(1);
			}
		if (!isdigit(*newversion) || *(newversion+1) != '.'
			|| !isdigit(*(newversion+2)) || !isdigit(*(newversion+3))) {
			printf("Warning - Version number not of the form N.NN\n");
			}
		}

	fd = open(fname,UPDATE);
	if (fd < 0) {
		printf("Can't open '%s' for read/write\n",fname);
		exit(1);
		}

	len = read(fd,buf,BUFFSIZE);
	while (1) {
		if (len == BUFFSIZE) len += read(fd,buf+BUFFSIZE,BUFFSIZE);
		*(buf+len) = 0;	/* prevent this unlikely bug */
		bufmod = 0;
		SearchAndFix(len,newversion);
		if (bufmod) {
			lseek(fd,(long)(-len),1);
			write(fd,buf,len);
			}
		len -= BUFFSIZE; if (len < 0) break;
		movmem(buf+BUFFSIZE,buf,len);
		}
	close(fd);
	}

struct tm *localnow(void) {long t; t=time(NULL); return(localtime(&t));}

char *mth[] = {
	"Jan","Feb","Mar","Apr","May","Jun","Jul","Aug","Sep","Oct","Nov","Dec"};

SearchAndFix(len,newversion)
	int len;
	char *newversion;
	{
	int *time;
	char *cptr;
	if (newversion) {
		cptr = buf;
		while(1) {
			cptr = memchr(cptr,'V',len-(cptr-buf));
			if (!cptr) break;
			if (match(cptr,"Version ")) cptr += 8; else cptr++;
			if (isdigit(*cptr) && *(cptr+1)=='.' && isdigit(*(cptr+2)) &&
				(*(cptr+3) == 'X' || *(cptr+3) == 'x'))
				makemod(cptr,newversion);
			cptr++;
			}
		}
	time = (int *)localnow();
	cptr = buf;
	while(1) {
		cptr = memchr(cptr,'d',len-(cptr-buf));
		if (!cptr) break;
		if (match(cptr,"dd-mmm-yy")) {
			char tbuf[10];
			sprintf(tbuf,"%2d-%s-%02d",time[3],mth[time[4]],time[5]);
			makemod(cptr,tbuf);
			}
		cptr++;
		}
	}

match(src,target)
	char *src,*target;
	{
	while (*src == *target || *src == toupper(*target)) {
		src++,target++;
		if (!*target) return(TRUE);
		}
	return(FALSE);
	}

makemod(cptr,mod)
	char *cptr,*mod;
	{
	char *x;
	x = cptr;
	while (*mod) *x++ = *mod++;
	bufmod = TRUE;
	while (cptr>buf && *(cptr-1)>=' ') cptr--;
	putchar('"');
	while (*cptr>=' ') putchar(*cptr++);
	putchar('"');
	putchar('\n');
	}
