/* Blinking text object by Joe Freeman 1/10 */
/*	((Idea by Charles Oei)) */
/*      Broken to work with IB by David Stutz 2/6 */

/*
/* Purpose:
/*	supply a simple interface to make blinking text
/*	for warning or informational messages
/*
/* Defaults
/*	1.0 second blink rate
/*	centered text
/*	no bezel
/*	no border
/*	no support
/*	you really don't want to enable editing or selection, do you?
 */

#import <appkit/TextField.h>

@interface BlinkTextField:TextField

{
  float	realGray;
  double interval;
  BOOL active;
  DPSTimedEntry teNum;
  int priority ;
  int which;
}

+ newFrame:(NXRect*)r;

- setTextGray:(float)g;
- flashGray;
- (float)realGray;

- setEditable:(BOOL)flag;
- setSelectable:(BOOL)flag;
- setBlink:(BOOL)flag;		/* YES starts blinking and NO stops it */
- deferredSetBlink:(BOOL)flag;
- setBlinkRate:(double)theRate;	/* seconds per blink */

- (double)blinkRate;
- (int)isBlinking;
- (double)blinkRate;
- (int)isBlinking;

- read:(NXTypedStream*)s;
- write:(NXTypedStream*)s;
- free;

- (const char*)inspectorName;

@end
