 /*
 *    Copyright, 1991, The Regents of the University of
 *    California.  This software was produced under a U. S.
 *    Government contract (W-7405-ENG-36) by the Los Alamos
 *    National Laboratory, which is operated by the
 *    University of California for the U. S. Department of
 *    Energy.  The U. S. Government is licensed to use,
 *    reproduce, and distribute this software.  Permission
 *    is granted to the public to copy and use this software
 *    without charge, provided that this Notice and any statement
 *    of authorship are reproduced on all copies.  Neither the
 *    Government nor the University makes any warranty, express
 *    or implied, or assumes any liability or responsibility for
 *    the use of this software.
 */

/* 
 * ConnectorView.h
 * By Bill Edney, Los Alamos National Laboratory
 */

#import <appkit/View.h>

/* The structure that holds our hit rectangles. Instances of these are known as "acceptors" */
typedef struct _ViewRectPair {
	id	view;
	NXRect	rect;
	} ViewRectPair;

@interface ConnectorView:View
{
	ViewRectPair *startAcceptor;	/* The acceptor that we start with */
	id			viewRectList;		/* Our own rectList */
	id			globRectList;		/* The global rectList */

	/* The various "long, thin" windows and rectangles for them */
	id			vertWindow, horizWindow,mDownWindow;
	NXRect		vertWinRect,horizWinRect,mDownRect;
	
	/* How thick we want the connection to be */
	float			connectionWidth;	
}

/* donor methods */
- initFrame:(const NXRect *)frameRect;
- awake;
- registerRect:(NXRect *)rect forView:view;
- buildGlobalRectList;
- (ViewRectPair *)checkForAcceptRect:(NXPoint)thePoint;
- drawSelf:(NXRect *)r :(int)count;

- (float)connectionWidth;
- setConnectionWidth:(float)theWidth;

- (id)viewRectList;

- (BOOL)acceptsFirstMouse;
- mouseDown:(NXEvent *)theEvent;
- dragConnectionUsingStartPoint:(NXPoint)startPoint;
- mouseWentDown:(ViewRectPair *)acceptor;

/* acceptor methods */
- mouseCameIn:(ViewRectPair *)acceptor;
- mouseWentOut:(ViewRectPair *)acceptor;
- mouseDropped:(ViewRectPair *)fromAcceptor :(ViewRectPair *)toAcceptor;

/* inspector methods */
- (const char *)inspectorName;

/* read and write methods */
- read:(NXTypedStream *)stream;
- write:(NXTypedStream *)stream;

@end