 /*
 *    Copyright, 1991, The Regents of the University of
 *    California.  This software was produced under a U. S.
 *    Government contract (W-7405-ENG-36) by the Los Alamos
 *    National Laboratory, which is operated by the
 *    University of California for the U. S. Department of
 *    Energy.  The U. S. Government is licensed to use,
 *    reproduce, and distribute this software.  Permission
 *    is granted to the public to copy and use this software
 *    without charge, provided that this Notice and any statement
 *    of authorship are reproduced on all copies.  Neither the
 *    Government nor the University makes any warranty, express
 *    or implied, or assumes any liability or responsibility for
 *    the use of this software.
 */
 
 /* 
 * ConnectorViewInspector.m
 * By Bill Edney, Los Alamos National Laboratory
 */

#import <nib/InterfaceBuilder.h>
#import <appkit/Application.h>
#import <appkit/Control.h>
#import <appkit/Button.h>
#import <appkit/publicWraps.h>

#import "ConnectorView.h"
#import "ConnectorViewInspector.h"

@implementation ConnectorViewInspector

/*
 * finishLoading: and startUnloading are required 
 * for dynamic loading. If you are building a custom 
 * Interface Builder, these methods can be removed.
 */
 
+ finishLoading:(struct mach_header *)header 
{
	NIBDidLoadClass(self, header);
	return nil;
}

+ startUnloading 
{
	NIBWillUnloadClass(self);
	return nil;
}

- init
{
	[super init];
	[NXApp loadNibSection:"ConnectorViewInspector.nib" owner:self];

	return self;
}

- revert:sender
{
	[widthField setFloatValue:[object connectionWidth]];
	return [super revert:sender];
}

- ok:sender
{
	[object setConnectionWidth:[widthField floatValue]];
	return [super ok:sender];
}

@end