#import <appkit/View.h>
#import <dpsclient/dpsNeXT.h>

#define GAMEWIDTH  400  // Default and generic.  Be more clever about setting.
#define GAMEHEIGHT 400

@interface TemplateView:View 
{
   
   int score, level, lives, highScore;

   BOOL gameRunning, demoMode;

   DPSTimedEntry timer;

   id image, backGround;

   // The following six are outlets set when the nib file is being
   // read in.
   
   // Views that display various info (these can be nil, in which case the
   // corresponding info will just go to the bit bucket). 
   
   id scoreView;
   id livesView;
   id levelView;
   id hscoreView;
   id statusView;

   id soundGenerator;
   
   // Base image parameters
   float imageX, imageY, imageXVel, imageYVel, imageXAccel, imageYAccel;
   float leftMargin;

   NXSize imageSize;

}

// The following methods can be called by Interface Builder objects &
// during creation/destruction of instances of BreakView.

- initFrame:(const NXRect *)frm;
- free;

- gotoFirstLevel:sender;  // Essentially a "new game"
- gotoNextLevel:sender;   // Doesn't have to be explicitly called by user
- setDemoMode:sender;     // Meant to be connected to switch with binary state
- go:sender;              // mouseDown: on the view does the same thing
- stop:sender;

- changeBackground:sender;
- revertBackground:sender;

// Methods to get back status of game.

- (int)score;
- (int)level;
- (int)lives;

// The following methods are internal and probably should not be called
// by others.

- setBackgroundFile:(const char *)fileName andRemember:(BOOL)remember;
- setHighScore:(int)hScore;
- getHighScore;
- drawSelf:(NXRect *)rects :(int)rectCount;
- drawBackground:(NXRect *)rect;
- eraseImage;
- showImage:(id)anImage;
- incrementGameScore:(int)scoreIncrement;
- step;
- playNote:(double)freq;
-(BOOL)acceptsFirstMouse;
-(BOOL)acceptsFirstResponder;

@end
