#import <appkit/View.h>
#import <appkit/NXImage.h>
#import <dpsclient/dpsclient.h>
#include <sys/types.h>

@interface Background:View
{
  char **imageNames;
  time_t *imageTimes;
  NXImage **images;
  int imageCount, max, current;
  char *defaultfile;
  double repeat;
  DPSTimedEntry  timer;
  id repeatText;
  BOOL permanent;
  id menu;
  BOOL updateMenu;
}

- initFrame:(const NXRect *)frameRect;
- reset;
- free;
//
//
//
- loadImageNamed:(const char *)aName;
- setImageNamed:(const char *)aName;
- setRepeatValue:(float)r;
- setRepeatText:aText;
- setPermanent:(BOOL)flag;
//
//	target/action
//
- open:sender;
- resize:sender;
- next:sender;
- previous:sender;
- redraw:sender;
- select:sender;
- toFront:sender;
- delete:sender;
- deleteAll:sender;
- takeRepeatValueFrom:sender;

- setMenu:aMenuCell;
- updateMenu;

- (int)getImage:(const char *)aName;
- setImage:(int)i;

- readDefault;
- writeDefault;

- mouseDown:(NXEvent *)event;
- (BOOL)acceptsFirstMouse;
- drawSelf:(NXRect *)r :(int)count;

@end
