
/* Generated by Interface Builder */

#import <libc.h>
#import <sys/time.h>

#import <appkit/Application.h>
#import <appkit/View.h>
#import <appkit/NXImage.h>
#import <appkit/Panel.h>
#import <soundkit/Sound.h>

#import "InfoMgr.h"


void blinkTimerProc ( DPSTimedEntry teNumber, double now, char *userData )
{
	[ (id) userData blink ] ;
	return ;
}


@implementation InfoMgr

- init
{
	standardIcon = [ NXImage findImageNamed: "Sentinel" ] ;
	fuzzIcons [ 0 ] = [ NXImage findImageNamed: "Fuzz1" ] ;
	fuzzIcons [ 1 ] = [ NXImage findImageNamed: "Fuzz2" ] ;
	fuzzIcons [ 2 ] = [ NXImage findImageNamed: "Fuzz3" ] ;
	blinkIcons [ 0 ] = [ NXImage findImageNamed: "Blink1" ] ;
	blinkIcons [ 1 ] = [ NXImage findImageNamed: "Blink2" ] ;

	staticSound = [ Sound findSoundFor: "Static.snd" ] ;

	return [ super init ] ;
}


- openInfo: sender
{
	int				animationCounter ;
	long				milTimer ;
	struct timeval		tp ;
	struct timezone	tzp ;

	if ( isInfoOpen )
	{
		return self ;
	}

	[ infoIcon setFlipped: NO ] ;
	[ infoPanel makeKeyAndOrderFront: self ] ;

	[ staticSound play ] ;
	gettimeofday ( &tp,& tzp ) ;
	milTimer = tp.tv_usec ;
	for ( animationCounter = 0 ; animationCounter < 100 ; animationCounter++ )
	{
		while ( ( tp.tv_usec >= milTimer ) && ( tp.tv_usec < milTimer + 5000 ) )
		{
			gettimeofday ( &tp, &tzp ) ;
		}
		milTimer = tp.tv_usec ;
		
		[ self drawIcon: fuzzIcons [ animationCounter % 3 ] ] ;
	}
	[ self drawIcon: blinkIcons [ 0 ] ] ;

	blinkEntry = DPSAddTimedEntry ( 0.5, (DPSTimedEntryProc) blinkTimerProc, (void *) self,
			NX_MODALRESPTHRESHOLD ) ;
	isInfoOpen = YES ;	
	return self ;
}


- windowWillClose: sender
{
	int				animationCounter ;
	long				milTimer ;
	struct timeval		tp ;
	struct timezone	tzp ;
	
	isInfoOpen = NO ;
	DPSRemoveTimedEntry ( blinkEntry ) ;

	[ staticSound play ] ;
	gettimeofday ( &tp, &tzp ) ;
	milTimer = tp.tv_usec ;
	for ( animationCounter = 0 ; animationCounter < 100 ; animationCounter++ )
	{
		while ( ( tp.tv_usec >= milTimer ) && ( tp.tv_usec < milTimer + 5000 ) )
		{
			gettimeofday ( &tp, &tzp ) ;
		}
		milTimer = tp.tv_usec ;

		[ self drawIcon: fuzzIcons [ animationCounter % 3 ] ] ;
	}
	[ self drawIcon: standardIcon ] ;

	[ infoPanel orderOut: self ] ;

	return self ;
}


- blink
{
	[ self drawIcon: blinkIcons [ random ( ) % 8 ? 0 : 1 ] ] ;
	return self ;
}


- drawIcon: (id) theIcon
{
	NXPoint			thePoint = { 8, 8 } ;

	[ [ [ NXApp appIcon ] contentView ] lockFocus ] ;
	[ theIcon composite: NX_SOVER toPoint: &thePoint ] ;
	[ [ [ NXApp appIcon ] contentView ] unlockFocus ] ;
	[ [ NXApp appIcon ] flushWindow ] ;

	[ infoIcon lockFocus ] ;
	[ theIcon composite: NX_SOVER toPoint: &thePoint ] ;
	[ infoIcon unlockFocus ] ;
	[ [ infoIcon window ] flushWindow ] ;

	return self ;
}

@end
