/*
 * Copyright 1990, John G. Myers
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 1, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#import <stdlib.h>
#import <appkit/Application.h>
#import <appkit/Window.h>
#import <appkit/View.h>
#import <appkit/Menu.h>
#import "EtermApp.h"
#import "EtermView.h"
#import "InfoDistributor.h"

void main(int argc, char *argv[])
{
    id window, view, infoDistributor;
    NXRect contentRect;
    Menu *menu, *infomenu, *editmenu;
    
    [EtermApp new];
    [NXApp setDelegate:NXApp]; /* So we can get the appDidInit message */

    window = [Window newContent:NULL
	  	     style:NX_TITLEDSTYLE
	  	     backing:NX_RETAINED
	  	     buttonMask:NX_MINIATURIZEBUTTONMASK|NX_RESIZEBUTTONMASK
		     defer:NO];

    [window setTitle:"GNU Emacs"];
    [window removeFromEventMask:NX_KEYUPMASK|NX_FLAGSCHANGEDMASK];

    view = [EtermView new];
    [NXApp setEtermView:view];

    [window setContentView:view];
    [window setBackgroundGray:NX_WHITE];
    [window makeFirstResponder:view];
    [window setDelegate:view];

    infoDistributor = [InfoDistributor new];
    infomenu = [Menu newTitle:"Info"];
    [[infomenu addItem:"Info panel..." action:@selector(showInfo:)
		keyEquivalent:'\0'] setTarget:infoDistributor];
    [[infomenu addItem:"Help..." action:@selector(helpBasics:)
		keyEquivalent:'?'] setTarget:infoDistributor];
    [[infomenu addItem:"Copying..." action:@selector(helpCopying:)
		keyEquivalent:'\0'] setTarget:infoDistributor];
    [infomenu sizeToFit];

    /* Standard mininmal Edit submenu */
    editmenu = [Menu newTitle:"Edit"];
    [[editmenu addItem:"Cut" action:@selector(cut:) keyEquivalent:'x']
		setTarget:view];
    [[editmenu addItem:"Copy" action:@selector(copy:) keyEquivalent:'c']
		setTarget:view];
    [[editmenu addItem:"Paste" action:@selector(paste:) keyEquivalent:'v']
		setTarget:view];
    [[editmenu addItem:"Undo" action:@selector(undo:) keyEquivalent:'z']
		setTarget:view];
    [editmenu sizeToFit];

    /* A rather minimal main menu as well */
    menu = [Menu newTitle:"Emacs"];
    [menu setSubmenu:infomenu
		forItem:[menu addItem:"Info" action:0 keyEquivalent:'\0']];
    [menu setSubmenu:editmenu
		forItem:[menu addItem:"Edit" action:0 keyEquivalent:'\0']];
    [menu addItem:"Hide"
		action:@selector(hide:)
 		keyEquivalent:'h'];
    [menu addItem:"Quit"
		action:@selector(terminate:)
 		keyEquivalent:'q'];
    [menu sizeToFit];
    [NXApp setMainMenu:menu];

    [NXApp run];
    [NXApp free];
    exit(0);
}

