/*
 * Copyright 1990, John G. Myers
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 1, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#import "EtermApp.h"

@implementation EtermApp

- (BOOL)appAcceptsAnotherFile:sender
/* Added by J. Gregory 9-Oct-91. */
{
	return YES;
}

- setEtermView:(id)anObject;
{
    etermView = anObject;
}

- etermView
{
    return etermView;
}

/*
 * We're ready to start.  Size the window apropriately and fire up the
 * emacs process, possibly editing a file.
 */
- appDidInit:(id)sender
{
	NXRect frameRect;
	int x, y;
	int rows, columns;

	DPSSetDeadKeysEnabled(DPSGetCurrentContext(),NO);

	rows = atoi(NXGetDefaultValue("Emacs", "Rows"));
	columns = atoi(NXGetDefaultValue("Emacs", "Columns"));
	[etermView sizeWindowTo: columns: rows];
	[[etermView window] getFrame : &frameRect];

	x = atoi(NXGetDefaultValue("Emacs", "WinLocX"));
	y = screenSize.height -
	    frameRect.size.height -
	    atoi(NXGetDefaultValue("Emacs", "WinLocY"));

	if (x + frameRect.size.width > screenSize.width)
	  x = screenSize.width - frameRect.size.width;
	if (y < 0) y = 0;

	if (x < 0) x = 0;
	if (y > screenSize.height - frameRect.size.height)
	  y = screenSize.height - frameRect.size.height;

	[[etermView window] moveTo: (NXCoord)x: (NXCoord)y];
	[etermView startEmacs: fileToEdit];
	if (!strcmp(NXGetDefaultValue("Emacs", "NXAutoLaunch"), "YES") &&
	    !strcmp(NXGetDefaultValue("Emacs", "HideOnAutoLaunch"), "YES")) {
	    [self hide: nil];
	}
	return self;
}


/*
 * Intercept the Quit command and replace it with C-x C-c.
 */
-terminate:(id)sender
{
    if (sender && [etermView quitEmacs]) return self;
    return [super terminate:sender];
}

  
/*
 * Stash the name of a file in an instance variable so we
 * can give it to the child emacs when we fire it up.
 *
 * TODO: Later versions may want to send an "(event-open "foo")"
 * message if the child emacs is already started.  So far, I
 * haven't found out how to get Emacs to get open requests for
 * text files, yet get Edit to eat RTF files.  Also, it's not clear
 * whether all (or most) users of Emacs will want it to replace
 * Edit that way.
 *
 * We should probably also handle multiple appOpenFile:type: messages
 * before the appDidInit: message.
 */
- (int)appOpenFile:(const char *)path type:(const char *)type
/* Modified by J. Gregory on 9-Oct-91. */
{
	if ([etermView emacsOn]) {	/* Then open file in a new buffer */
    	[etermView openFile:path];
	} else { /* set the startup file to edit */
    	fileToEdit = malloc(strlen(path)+1);
    	strcpy(fileToEdit, path);
	}
    return YES;
}

@end






