/*
 * 1990, John G. Myers
 * This file is in the public domain.
 */

/*
 * Grab a copy of the keyboard translation table so we can find the
 * charCode for a given keyCode, ignoring the Alternate key.
 */

#include <stdio.h>
#include <stdlib.h>
#include <libc.h>
#include <limits.h>
#include <sys/file.h>
#include <sys/types.h>
#include <nextdev/evsio.h>
#include <nextdev/keycodes.h>
#include <dpsclient/dpsclient.h>

static char keycode[256][4];
static havekeymap = 0;

static
int mask_skip(char mask)	/* Given a char mask for a key, */
{				/* this computes the number */
  int i, skip;			/* of chars generated by the */
				/* key. */
  if (mask == -1) return 0;

  for (i = CHAR_BIT, skip = 1; i > 0; i--, mask >>=1)
    if (mask&01) skip <<=1;
  return skip;
}

void kc_init()
{
    int evs_fd;
    struct evsioKeymapping map;
    char evfs, nks, km;
    int mask, skip;
    int kc, kcs;
    int i;
    char *mapping;

    if ((evs_fd = open("/dev/evs0", O_RDWR, 0)) < 0) {
	perror("Emacs: /dev/evs0");
	return;
    }
    if (ioctl(evs_fd, EVSIOCKML, &map.size) < 0) {
	perror("Emacs: ioctl EVSIOCKML");
	return;
    }
    map.mapping = (char*) malloc(map.size);
    if (ioctl(evs_fd, EVSIOCKM, &map) < 0) {
	perror("Emacs: ioctl EVSIOCKM");
	return;
    }				/* Check mapping format. */
    if (map.mapping[0] || map.mapping[1]) {
	fprintf(stderr, "Emacs: unknown keyboard map format.\n");
	return;
    }


    mapping = map.mapping + 2;

    for (evfs = *mapping++; evfs > 0; evfs--) { /* Skip event flags. */
	mapping++;			/* Skip bit number. */
	nks = *mapping++;		/* Number of keys assigned to bit. */
	mapping += nks;		/* Skip key codes. */
    }

    kcs = (unsigned char) *mapping++;	/* kcs = number of key defs. */

    for (kc = 0; kc < kcs; kc++) {
	mask = *mapping++;		/* Get mask */
	skip = mask_skip(mask);

	keycode[kc][0] = mapping[1];
	if (mask & 3) {		/* Shift key */
	    /* Assumes only one bit will be set */
	    keycode[kc][1] = mapping[3];

	    if (mask & 4) {	/* Control key */
		keycode[kc][2] = mapping[5];
		keycode[kc][3] = mapping[7];
	    }
	    else {
		keycode[kc][2] = keycode[kc][0];
		keycode[kc][3] = keycode[kc][1];
	    }
	}
	else {
	    keycode[kc][1] = keycode[kc][0];

	    if (mask & 4) {
		keycode[kc][2] = keycode[kc][3] = mapping[3];
	    }
	    else {
		keycode[kc][2] = keycode[kc][3] = keycode[kc][0];
	    }
	}

	mapping += 2*skip;		/* Skip defs. */
    }

    havekeymap=1;
}

int kc_keyforcode(code, flags)
int code, flags;
{
    int modifier = 0;

    if (!havekeymap) return -1;

    if (flags & NX_CONTROLMASK) modifier += 2;
    if (flags & NX_SHIFTMASK) modifier++;

    return keycode[code][modifier];
}
