;; Low-level subroutines for NeXT "Emacs" front end
;; Copyright (C) 1990 Free Software Foundation, Inc.

;; This file is NOT part of the standard GNU Emacs distribution.

;; GNU Emacs is distributed in the hope that it will be useful,
;; but WITHOUT ANY WARRANTY.  No author or distributor
;; accepts responsibility to anyone for the consequences of using it
;; or for whether it serves any particular purpose or works at all,
;; unless he says so in writing.  Refer to the GNU Emacs General Public
;; License for full details.

;; Everyone is granted permission to copy, modify and redistribute
;; GNU Emacs, but only under the conditions described in the
;; GNU Emacs General Public License.   A copy of this license is
;; supposed to have been given to you along with GNU Emacs so you
;; can know your rights and responsibilities.  It should be in a
;; file named COPYING.  Among other things, the copyright notice
;; and this notice must be preserved on all copies.

;;; Apr 4 '90 jgm	Ripped off of sun-fns.el

(provide 'eterm-low)

(defun eterm-send-terminal-string-function (string function)
  "Send a \\C-q quoted string to the terminal, then send function"
  (send-string-to-terminal (concat "\C-q" string "\377" function)))

(defun eterm-change-title (title)
  "Change the wm title for the gnumacs window."
  (interactive "sTitle: ")
  (eterm-send-terminal-string-function title "t"))

;(defun global-set-menu (item command)
;  "Add a command to the wm menus."
;  (interactive "sMenu item: \nCCommand: ")
;  (eterm-send-terminal-string-function
;   (concat item ":\C-[x" (prin1-to-string command) "\n") "m"))
;
;(defun global-unset-menu (item)
;  "Remove a menu item from the wm menus."
;  (interactive "sMenu item: ")
;  (eterm-send-terminal-string-function item "m"))
;
;(defun add-menu-item (item binding &optional page)
;  "Add a menu item to the menus.  (obsolete)"
;  (interactive "sItem: \nsBinding: \nsPage: ")
;  (eterm-send-terminal-string-function
;   (concat page (and page ", ")
;	   item (and binding (not (string= binding "")) ":") binding)
;   "m"))
;
;(defun remove-menu-item (item &optional page)
;  "Remove ITEM from the wm menus.  (obsolete)"
;  (interactive "sItem: \nsPage:")
;  (add-menu-item item "" page))

; something to hide without using the mouse
(defun eterm-hide-emacs ()
  "Ask the termulator to hide this window."
  (interactive)
  (send-string-to-terminal "\C-z"))

; cut buffer stuff

(defun eterm-send-region-to-cut-buffer (start end)
  "   Copy the region between point and mark to the NeXT cut buffer.
   This will not happen if the region contains a \\377."
  (interactive "r")
  (save-excursion
    (goto-char start)
    (if (search-forward "\377" end t)
	(error "Region contains illegal character for NeXT cut buffer.")
        (eterm-send-terminal-string-function
	 (buffer-substring start end) "c"))))

(defun eterm-send-region-to-cut-buffer-and-wipe (start end)
  "  As send-region-to-cut-buffer but also kill the text."
  (interactive "r")
  (barf-if-buffer-read-only)
  (eterm-send-region-to-cut-buffer start end)
  (kill-region start end))

;
; Event server stuff
;

(defvar eserver nil 
  "The event server process.")

(defun start-event-server ()
  (interactive)
  (let ((host (or (getenv "EVENT_HOST")
		  (error "Can't find host for event server")))
	(port (or (getenv "EVENT_PORT")
		  (error "Can't find port for event server"))))
    (setq eserver 
	  (open-network-stream " event-server" nil host
			       (string-to-int port))))
  (set-process-filter eserver 'event-filter)
  (set-process-sentinel eserver 'event-sentinel)
  (global-set-key "\C-x\C-@" 'eterm-mouse-handler))

(defun event-sentinel (process change)
  (message (concat  "The event handler has " change)))

(defvar event-partial-output ""
  "Incomplete, unprocessed output from the event server")

;;; Modified by J. Gregory 17-Oct-91.  Save match-end before match
;;; data gets crunched.
(defun event-filter (process string)
  ;; Add the incoming string to what we have:
  (let ((events (concat event-partial-output string)))
    ;; Each event is terminated with a newline.
    ;; Process events until we run out of newlines.
    (while (string-match "\n" events)	;sets match-data
      (let ((next (match-end 0)))
	(eval (car (read-from-string events)))
	(setq events (substring events next))))
    ;; Set global to be what we have not yet processed
    (setq event-partial-output events)))

; Handlers for the events that get sent to us.
;
(defun event-copy ()
  (eterm-send-region-to-cut-buffer (region-beginning) (region-end)))

(defun event-cut ()
  (eterm-send-region-to-cut-buffer-and-wipe (region-beginning) (region-end)))

(defun event-paste (str)
  (barf-if-buffer-read-only)
  (push-mark (point))
  (insert str))

(defun event-undo ()
  (undo)
  (setq last-command 'undo))

(defun event-quit ()
  (save-buffers-kill-emacs)
  (setq last-command 'save-buffers-kill-emacs))

;(defun event-resize (newx newy)
;  (if (or (not (= (screen-width) newx))
;	  (not (= (screen-height) newy)))
;      (progn
;	(set-screen-width newx)
;	(set-screen-height newy))
;    (redraw-display)))


