/*
 * Copyright 1990, John G. Myers
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 1, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <stdlib.h>
#include <stdio.h>
#include <strings.h>

static void process(char *);

main(argc, argv)
int argc;
char **argv;
{
    argv++;
    while (*argv) {
	process(*argv++);
    }
    exit(0);
}

static void process(filename)
char *filename;
{
    FILE *f;
    char name[128], *p;
    int c;

    f = fopen(filename, "r");
    if (!f) {
	perror(filename);
	exit(1);
    }

    sprintf(name, filename);
    p = index(name, '.');
    if (!p) p = name + strlen(name);
    strcpy(p, "help");

    printf("const char * const %s = \"", name);
    while ((c = getc(f)) != EOF) {
	switch(c) {
	case '\n':
	    printf("\\n\"\n\"");
	    break;
	case '\\':
	case '\"':
	    putchar('\\');
	    /* FALL THROUGH */
	default:
	    putchar(c);
	}
    }
    printf("\";\n");
    fclose(f);
}
