# This makefile is specific to the Next computer.  It will correctly install
# the RCS man pages replacing the ones supplied with the Next distribution.

# We need to change the man pages from 1L and 5L to 1 and 5, respectively
# to match those supplied with the Next distribution.

GNUSRCS =	ci.1l co.1l ident.1l rcs.1l rcsclean.1l rcsdiff.1l rcsfile.5l \
		rcsfreeze.1l rcsintro.1l rcsmerge.1l rlog.1l merge.1l

NextSRCS =	ci.1 co.1 ident.1 rcs.1 rcsclean.1 rcsdiff.1 rcsfile.5 \
		rcsfreeze.1 rcsintro.1 rcsmerge.1 rlog.1 merge.1

.SUFFIXES:	.5l .5 .1l .1

all:		$(NextSRCS)

clean:
		rm -f $(NextSRCS)

install:	$(NextSRCS)
		@for i in $?; do \
		   installman $$i; \
		done

# The sed patterns (1L and 5L) could end up matching more than just man
# section references.  We take the chance.

.1l.1:
		sed -e 's/\([15]\)L/\1/g' $*.1l > $*.1

.5l.5:
		sed -e 's/\([15]\)L/\1/g' $*.5l > $*.5
