/*
 * Written by Guy Roberts of Object Skills Ltd, drifting
 * in cyberspace without a domain or email address right 
 * now. 
 * May 7 1993. You can use this as a base for a better application
 * as long as it is made publically available.
 */

#import "RTF.h"
#import "Preferences.h"
#import <appkit/appkit.h>
#import <streams/streams.h>
#include <ctype.h>
#import <sys/stat.h>

@interface Translator:Object
{
	char		*name;
	id			objectSummary;
	NXStream	*fileStream;
	id			rtfInstance;
	int			numClassMethods;
	int			numInstanceMethods;
}

- initForHeaderFile: (char *) name withTable: table;
- (BOOL) parseBuffer: (char *) buffer withKeyWordTable: table;
- (BOOL) getClass: (char **) className 
	   andParentName: (char **) parentClassName
	   fromBuffer: (char **) buffer;
- insertOrdinaryText: (const char *) text;
- listInstanceVariables: (char **) buffer;
- (BOOL) getNextType: (char *) type andVariableName: (char *) name 
	fromBuffer: (char **) buffer;
- (BOOL) getInstanceMethods: (id *) instanceMethodStorage
	andClassMethods: (id *) classMethodStorage
	fromBuffer: (char **) buffer;
- (BOOL) getNamePart: (char **) name typePart: (char **) type
	argPart: (char **) arg fromString: (char **) string;
- writeMessageNames: instanceMethodStorage;
- writeMethods: table  stringTable: table;
- free;

@end
