/* Generated by Interface Builder */

#import <appkit/Application.h>
#import <appkit/ButtonCell.h>
#import <appkit/FormCell.h>
#import <appkit/Matrix.h>
#import <appkit/Panel.h>
#import <appkit/Slider.h>
#import <appkit/View.h>
#import <appkit/Window.h>
#import <objc/Object.h>
#import <sys/types.h>
#import <sys/socket.h>
#import <net/if.h>
#import <sys/param.h>
#import <sys/dk.h>
#define KERNEL
#import <sys/time.h>
#undef KERNEL
#import <sys/kernel.h>
#import <sys/vmmeter.h>
#import <vm/vm_statistics.h>

#import "StripChart.h"

#define APPLICATION		"Monitor"

#define	LOAD_AVERAGE		(0)
#define	USER_CPU_TIME		(1)
#define	SYSTEM_CPU_TIME		(2)
#define	IDLE_CPU_TIME		(3)
#define	TOTAL_CPU_TIME		(4)
#define	CONTEXT_SWITCHES	(5)
#define	SYSTEM_CALLS		(6)
#define	CALLS_TO_TRAP		(7)
#define	DEVICE_INTERRUPTS	(8)
#define	ADDRESS_FAULTS		(9)
#define	CACHE_HIT_RATE		(10)
#define	WIRED_PAGES		(11)
#define	ACTIVE_PAGES		(12)
#define	INACTIVE_PAGES		(13)
#define	FREE_PAGES		(14)
#define	TOTAL_PAGES		(15)
#define	PAGES_ALLOCATED		(16)
#define	PAGES_RECLAIMED		(17)
#define	PAGES_READ_IN		(18)
#define	PAGES_WRITTEN_OUT	(19)
#define	FIXED_DISK_TRANSFERS	(20)
#define	OPTICAL_DISK_TRANSFERS	(21)
#define	TOTAL_DISK_TRANSFERS	(22)
#define	ETHERNET_INPUT_PACKETS	(23)
#define	ETHERNET_OUTPUT_PACKETS	(24)
#define	ETHERNET_TOTAL_PACKETS	(25)
#define	ETHERNET_INPUT_ERRORS	(26)
#define	ETHERNET_OUTPUT_ERRORS	(27)
#define	ETHERNET_TOTAL_ERRORS	(28)
#define	ETHERNET_COLLISIONS	(29)
#define	NO_DISPLAY		(30)
#define	TOTAL_SELECTIONS	(NO_DISPLAY)

#define	WINDOW_DEFAULTS		(0)
#define	VIEW_DEFAULTS		(1)
#define	ICON_DEFAULTS		(2)
#define	DISPLAY_DEFAULTS	(3)

typedef struct
	{
	   long			avenrun[3];
	   struct vmmeter	cnt;
	   long			cp_time[CPUSTATES];
	   long			dk_seek[DK_NDRIVE];
	   struct ifnet		ifnet;
	   struct vm_statistics vm_stat;
	} Statistics;

@interface Monitor:Object
{
   Window	 *performance;
   Panel	 *selection;
   Matrix	 *viewSelect;
   FormCell	 *timeForm;
   Slider	 *timeSlider;
   ButtonCell	 *noButton;
   ButtonCell	 *okButton;

   Window	 *miniWindow;
   int		  miniSize;
   int		  miniWidth;
   int		  miniHeight;
   int		  miniBps;
   int		  miniSpp;
   int		  miniConfig;
   int		  miniMask;
   char		 *miniData;
   char		 *miniAlpha;

   char		  showview;
   char		  display[TOTAL_SELECTIONS];
   StripChart	 *subview[TOTAL_SELECTIONS];

   int		  showicon;
   StripChart	 *iconview;

   float	  updatetime;

   char		  hostname[MAXHOSTNAMELEN];
   int		  hostnamelen;

   struct timeval boottime;

   DPSTimedEntry  tmentry;
   struct timeval lastime;

   Statistics	  oldstats;
   Statistics	  newstats;
}

+ initialize;
+ new;

- free;

- setPerformance:anObject;
- setSelection:anObject;
- setViewSelect:anObject;
- setTimeForm:anObject;
- setTimeSlider:anObject;
- setNoButton:anObject;
- setOkButton:anObject;

- appDidInit:sender;
- appDidBecomeActive:sender;

- windowWillClose:sender;
- windowDidMove:sender;
- windowDidResize:sender;

- selectView:sender;
- endSelect:sender;
- selectIcon:sender;
- showView:sender;
- showIcon:sender;

@end
