#import <appkit/View.h>

@interface StripChart:View
{
   float  ceiling;
   float  factor;
   char  *title;

   char	  inited;

   float  xoffset;
   float  yoffset;

   float  width;
   float  height;

   float *_values;
   int	  index;
   int	  count;
   int	  number;

   float  maximum;

   float *upath;
   int	  nupath;
   char	 *uops;
   int	  nuops;
   float  ubbox[4];
}

#define values(i,j)	(_values[((i) << 2) + (j)])

+ newFrame:(const NXRect *) frameRect maximum:(float) maxval scale:(float) scale title:(char *) string;

- free;

- initGState;
- drawSelf:(const NXRect *) rects :(int) rectCount;

- plotStats:(float) black count:(int) samples;
- plotStats:(float) black :(float) dgray count:(int) samples;
- plotStats:(float) black :(float) dgray :(float) white count:(int) samples;
- plotStats:(float) black :(float) dgray :(float) lgray :(float) white count:(int) samples;
@end
