/* table() version of loadave() suggested by Morris Meyer (mmeyer@next.com) */

#include <c.h>
#include <sys/table.h>

#define QUEUES 3

extern int table();

int loadave(long vector[QUEUES])
{
	struct tbl_loadavg tl;
	int i;

	if(table(TBL_LOADAVG, 0, &tl, 1, sizeof(tl)) == CERROR) return(CERROR);

	if(tl.tl_lscale == 0) return(CERROR);

	for (i = 0; i < QUEUES; i++) vector[i] = tl.tl_avenrun[i];

	return(tl.tl_lscale);
}
