#import <appkit/View.h>

#import "NLoadCommon.h"

typedef enum {ALL = -1, Q1MIN, Q5MIN, Q15MIN, QUEUES} QueueType;

void timer(DPSTimedEntry, double, id);

@interface LoadView : View
{
	DPSTimedEntry timedEntry;

	float maxLoad, load[(int) WIDTH][QUEUES];

	int index, queue, nErrors;

	const char *hostName;
}

- initFrame:(const NXRect *) frameRect;
- drawSelf:(const NXRect *) rects :(int) rectCount;
- free;

- startTimer;

- (float) getLoadAverage:(int) offset;
- loadAverage:(long *)vector loadScale:(int *)scale;

- drawOneLoad:(int) offset;
- displayAll:(float) color;

- moveArray;
- (float) maxOfArray;

- setHostName:(const char *) name;

@end
