#import <rpcsvc/rstat.h>

#import "RPCLoadView.h"
#import "NLoadCommon.h"

@implementation RPCLoadView

- startTimer
{
	const char *string;
	int time = REMOTEUPDATE;

	if ((string = getDefault("RemoteUpdateSeconds")) && sscanf(string, "%d", &time) != 1)
		time = REMOTEUPDATE;
	
	timedEntry = DPSAddTimedEntry((double) time, (DPSTimedEntryProc) &timer, self, NX_BASETHRESHOLD);
	
	return self;
}

extern int rstat(const char *, struct statstime *);

- loadAverage:(long *) vector loadScale:(int *) scale
{
	struct statstime stats;
	int i;
   
	if(rstat(hostName, &stats) != 0) return nil;

	for (i = 0; i < QUEUES; i++) vector[i] = stats.avenrun[i];
   
	*scale = FSCALE;
   
	return self;
}

@end
