
/* Generated by Interface Builder */

#import "Qwatch.h"

@implementation Qwatch

- setTheStatusField:anObject
{
	TheStatusField = anObject;
	return self;
}

- setThePasswordField:anObject
{
	ThePasswordField = anObject;
	return self;
}

- setTheScrollView:anObject
{
	TheScrollView = anObject;
	return self;
}

- setPassword:sender
{
	return self;
}

- deleteJob:sender
{
	int i;
	char str[64];

	if (selentry < 0) {
		NXBeep();
		return self;
	}
	
	for (i = 0; i < qtop && queue[i] != selentry; i++);
	if (i >= qtop) {
		NXBeep();
		return self;
	}
	
	if ((int)jobowner[i]
		|| (!strcmp(username,"root"))
		|| (!strcmp(username,"cs124"))
		|| (!strcmp(username,"cs126"))
		) {
		sprintf(str,"lprm -P%s %d",PRINTER,selentry);
		system(str);
		return(self);
	}
	
	return self;
}

- appDidInit:sender
{
	void updateFunction();
	NXRect textRect;

	delay = 5.0;
	qtop = 0;
	selentry = -1;
	strcpy(username,(getpwuid(getuid()))->pw_name);

	textRect.origin.x = textRect.origin.y = 0.0;
	[TheScrollView getContentSize: &(textRect.size)];
	TheText = [BrowseText newFrame:&textRect text:NULL alignment:NX_LEFTALIGNED];
	[TheText setQwatch:self];
	[TheText notifyAncestorWhenFrameChanged:YES];
	[TheText setHorizResizable:NO];
	[TheText setVertResizable:YES];
    
	textRect.size.width = 0.0;
	[TheText setMinSize:&(textRect.size)];
	[TheScrollView getContentSize: &(textRect.size)];
	textRect.size.height = 1000000;
	[TheText setMaxSize:&(textRect.size)];
    
	[[TheText superview] setAutoresizeSubviews:YES];
	[[TheText superview] setAutosizing: NX_HEIGHTSIZABLE | NX_WIDTHSIZABLE];
    
	[TheText setCharFilter: NXFieldFilter];
	[TheText setMonoFont: FALSE];
	OwnerFont = [Font newFont:"Courier-Bold" size:12];
	OtherFont = [Font newFont:"Courier" size:12];
	[TheText setFont: OtherFont];
	lineheight = [TheText lineHeight];
	[TheScrollView setDocView: TheText];
	[self updateOutput];

	tentry = DPSAddTimedEntry(delay,&updateFunction,self,NX_BASETHRESHOLD);

	return self;
}

- (char *)stringValue
{
	return status;
}

void updateFunction(DPSTimedEntry te, double timeNow, void *data)
{
	id self;
	
	self = data;
	[self updateOutput];
}
	
- updateOutput
{
	char str[128], oline[128], ofile[64], Pfiles[40], Powner[16];
	FILE *fp, *fopen();
	int n, Pjob, Psize, locn, seln;
	
	sprintf(ofile,"%s.%d",QFILE,getpid());
	sprintf(str,"lpq -P%s > %s",PRINTER,ofile);
	system(str);
	fp = fopen(ofile,"r");

	fgets(str,128,fp);
	str[strlen(str) - 1] = '\0';
	sprintf(status,"%s %s",PRINTER,str);
	
	[TheStatusField takeStringValueFrom:self];

	while (NULL != fgets(str,128,fp) && strncmp(str,"Rank",4)) ;
	
	seln = -1;
	n = 0;
	locn = 0;
	
	while (n < QSIZE && NULL != fgets(str,256,fp)) {
		sscanf(str+7,"%s",Powner); /* owner name at str[7] */
		sscanf(str+18,"%d",&Pjob); /* job number at str[18] */
		strncpy(Pfiles,str+23,38); /* files at str[23], length 38 */
		Pfiles[38] = '\0';
		sscanf(str+61,"%d",&Psize); /* job size at str[61] */
		sprintf(oline,"%3d   %8s   %7d   %38s\n",Pjob,Powner,Psize,Pfiles); /* PSIZE BYTES */
		
		if (n >= qtop || Pjob != queue[n]) {
			if (n >=qtop) {
				[TheText setSel :locn :locn];
				[TheText replaceSel :" "];
				[TheText setSel :locn :(locn + 1)];
			}
			else [TheText setSel :locn :(locn + PSIZE)];
			
			if (!strcmp(username,Powner)) {
				[TheText setSelFont :OwnerFont];
				jobowner[n] = (char)1;
			}
			else {
				[TheText setSelFont :OtherFont];
				jobowner[n] = (char)0;
			}

			[TheText replaceSel :oline];
		}
	
		queue[n] = Pjob;
		if (Pjob == selentry) seln = n;
		n++;
		locn += PSIZE;
	}
	
	[TheText setSel:locn :[TheText textLength]];
	[TheText replaceSel :""];
	
	qtop = n;
	
	fclose(fp);
	
	if (seln >= 0) {
		locn = seln * PSIZE;
		[TheText setSel :locn :(locn + PSIZE)];
	}
	return self;
}

- mouseSelected:(NXPoint *)pt
{
	int line, locn;
	double y;
	
	y = pt->y / (double)lineheight;
	line = y;
	if (line < qtop) {
		selentry = queue[line];
		locn = line * PSIZE;
		[TheText setSel :locn :(locn + PSIZE)];
	}
	else selentry = -1;

	return self;
}

@end
