
/* Generated by Interface Builder */

#import "Quota.h"

@implementation Quota

- setNameField:anObject
{
	NameField = anObject;
	return self;
}

- setDiskUsageField:anObject
{
	DiskUsageField = anObject;
	return self;
}

- setDiskQuotaField:anObject
{
	DiskQuotaField = anObject;
	return self;
}

- setPageUsageField:anObject
{
	PageUsageField = anObject;
	return self;
}

- setPageQuotaField:anObject
{
	PageQuotaField = anObject;
	return self;
}

- setAuthorizationWindow:anObject
{
	AuthorizationWindow = anObject;
	return self;
}

- setQuotasWindow:anObject
{
	QuotasWindow = anObject;
	return self;
}

- setPasswordField:anObject
{
	PasswordField = anObject;
	return self;
}

/*  This is where the real work is done */

- setName:sender
{
	char str[256];
	int getprop();
	struct passwd *getpwuid(), *getpwnam();
	FILE *fp, *fopen();

	strcpy(str,[sender stringValue]);
	if (!authorized)  {
		[NameField takeStringValueFrom:self];
		NXBeep();
		return self;
	}

	if (getpwnam(str) == NULL) {
		[NameField takeStringValueFrom:self];
		NXBeep();
		return self;
	}

	strcpy(Name,str);
	[NameField takeStringValueFrom:self];
	[NameField setBackgroundGray:BLACK];
	[NameField setTextGray:WHITE];
	[NameField display];
	
	Name[0] = '\0';
	[DiskUsageField takeStringValueFrom:self];
	[DiskQuotaField takeStringValueFrom:self];
	[PageUsageField takeStringValueFrom:self];
	[PageQuotaField takeStringValueFrom:self];
	[DiskUsageField display];
	[DiskQuotaField display];
	[PageUsageField display];
	[PageQuotaField display];
	[PageQuotaField display];

	strcpy(Name,str);
	pw_entry = getpwnam(Name);
	sprintf(str,"/users/%s",Name);
	ni_pathsearch(NetInfohandle, &NetInfoid, str);
	
	if (!strncmp(pw_entry->pw_dir,"/Users",6)) {
		sprintf(str,"cd %s; du -s . > /tmp/du",pw_entry->pw_dir);
		system(str);
		fp = fopen("/tmp/du","r");
		fscanf(fp,"%d",&DiskUsage);
		fclose(fp);
		system("rm -f /tmp/du");
	}
	else DiskUsage = 0;
	DiskQuota = getprop(NetInfohandle, &NetInfoid, DQPROP);
	PageUsage = getprop(NetInfohandle, &NetInfoid, PUPROP);
	PageQuota = getprop(NetInfohandle, &NetInfoid, PQPROP);

	[NameField takeStringValueFrom:self];
	[NameField setBackgroundGray:WHITE];
	[NameField setTextGray:BLACK];
	[NameField display];
	[DiskUsageField setIntValue:DiskUsage];
	[DiskQuotaField setIntValue:DiskQuota];
	[PageUsageField setIntValue:PageUsage];
	[PageQuotaField setIntValue:PageQuota];
	return self;
}

- setDiskUsage:sender
{
	NXBeep();
	[DiskUsageField setIntValue:DiskUsage];
	return self;
}

- setDiskQuota:sender
{
	int v;
	int setprop();

	if (!authorized) {
		NXBeep();
		[DiskQuotaField setIntValue:DiskQuota];
		return self;
	}

	v =  setprop(NetInfohandle, &NetInfoid, DQPROP, [sender intValue]);
	if (v < 0) NXBeep();
	else DiskQuota = v;
	
	[DiskQuotaField setIntValue:DiskQuota];
	return self;
}

- setPageUsage:sender
{
	int v;
	int setprop();

	if (!authorized) {
		NXBeep();
		[PageUsageField setIntValue:PageUsage];
		return self;
	}

	v =  setprop(NetInfohandle, &NetInfoid, PUPROP, [sender intValue]);
	if (v < 0) NXBeep();
	else PageUsage = v;
	
	[PageUsageField setIntValue:PageUsage];
	return self;
}

- setPageQuota:sender
{
	int v;
	int setprop();

	if (!authorized) {
		NXBeep();
		[PageQuotaField setIntValue:PageQuota];
		return self;
	}

	v =  setprop(NetInfohandle, &NetInfoid, PQPROP, [sender intValue]);
	if (v < 0) NXBeep();
	else PageQuota = v;
	
	[PageQuotaField setIntValue:PageQuota];
	return self;
}

- (char *)stringValue
{
	return Name;
}

- setPassword:sender
{
	char str[64], salt[3], tmp;
	struct passwd  *pw_root, *getpwuid();
	
	/* Get the password string */
	strcpy(str,[sender stringValue]);
	
	/* Blank the password input field, and reset it */
	tmp = Name[0];
	Name[0] = '\0';
	[PasswordField takeStringValueFrom:self];
	[PasswordField selectText:self];
	[PasswordField display];
	Name[0] = tmp;
	
	/* Fetch root's password, and test the input password against it */
	pw_root = getpwuid(0);
	salt[0] = pw_root->pw_passwd[0];
	salt[1] = pw_root->pw_passwd[1];
	salt[2] = '\0';
	if  (!strcmp(pw_root->pw_passwd,crypt(str,salt))) {
		/* Password correct .  Make the Authorization Window go away */
		[AuthorizationWindow performClose:self];

		/* Set NetInfo name and password */
		ni_setpassword(NetInfohandle,str);
		ni_setuser(NetInfohandle,"root");
		authorized = 1;
		
		/* Enable the text fields */
		[NameField setEnabled:YES];
		[NameField setTextGray:BLACK];
		[DiskUsageField setEnabled:YES];
		[DiskQuotaField setEnabled:YES];
		[PageUsageField setEnabled:YES];
		[PageQuotaField setEnabled:YES];

		[NameField display];
		[DiskUsageField display];
		[DiskQuotaField display];
		[PageUsageField display];
		[PageQuotaField display];
	}
	else {
		/* Flash the text field and Beep*/
		[PasswordField setBackgroundGray:BLACK];
		[PasswordField display];
		[PasswordField setBackgroundGray:WHITE];
		[PasswordField display];
		NXBeep();
	}

	return self;
}

-appDidInit:sender
{
	struct passwd *getpwuid(), *getpwuid();
	int getprop();
	char str[64];
	
	[QuotasWindow makeKeyAndOrderFront:self];

	/* Disable the text fields (until the user is authorized) */
	[NameField setEnabled:NO];
	[DiskUsageField setEnabled:NO];
	[DiskQuotaField setEnabled:NO];
	[PageUsageField setEnabled:NO];
	[PageQuotaField setEnabled:NO];
	
	[NameField display];
	[DiskUsageField display];
	[DiskQuotaField display];
	[PageUsageField display];
	[PageQuotaField display];
	
	/* Get current user's name */
	pw_entry = (struct passwd *)malloc(sizeof(struct passwd));
	pw_entry = getpwuid(getuid());
	strcpy(Name,pw_entry->pw_name);

	/* Open NetInfo */
	ni_open(NULL, DOMAIN, &NetInfohandle);
	
	/* Authorize this user fro a one-shot run through setName */
	authorized = 1;
	[self setName:self];
	authorized = 0;
	
	/* Reset the Name field to gray */
	[PasswordField selectText:self];
	[NameField setTextGray:DARKGRAY];
	[NameField display];
	return self;
}

int getprop(h,i,p)
void *h;
ni_id *i;
char  *p;
{
	int v;
	ni_namelist nl;

	if (ni_lookupprop(h,i,p,&nl)) return(0);
	sscanf(nl.ni_namelist_val[0],"%d",&v);
	return(v);
}

int setprop(h,i,p,v)
void *h;
ni_id *i;
char  *p;
int v;
{
	ni_namelist nl;
	ni_property prop;
	ni_proplist pl;
	ni_index index;
	ni_status rc;
	char str[16];
	
	rc = ni_lookupprop(h,i,p,&nl);
	sprintf(str,"%d",v);
	
	if (rc == NI_NOPROP) {
		prop.nip_name = malloc(strlen(p) + 1);
		strcpy(prop.nip_name,p);
		prop.nip_val.ni_namelist_len = 1;
		prop.nip_val.ni_namelist_val = malloc(sizeof(char *));
		prop.nip_val.ni_namelist_val[0] = malloc(QSIZE);
		strcpy(prop.nip_val.ni_namelist_val[0],str);
		rc = ni_createprop(h,i,prop,NI_INDEX_NULL);
		if (rc) fprintf(stderr,"createprop failed!  rc=%d\n",rc);
		if (rc) return(-1);
	}
	else {
		ni_read(h,i,&pl);
		index = ni_proplist_match(pl,p,NULL);
		nl.ni_namelist_len = 1;
		nl.ni_namelist_val = malloc(sizeof(char *));
		nl.ni_namelist_val[0] = malloc(QSIZE);
		strcpy(nl.ni_namelist_val[0],str);
		rc = ni_writeprop(h,i,index,nl);
		if (rc) fprintf(stderr,"writeprop failed!  rc=%d\n",rc);
		if (rc) return(-1);
	}

	return(v);
}

@end

