#include <netinfo/ni.h>
#include <stdio.h>
#include "quota.h"

main(argc,argv)
int argc;
char *argv[];
{
	ni_status rc, ni_printdir();
	void *myhandle;
	ni_namelist mynamelist;
	ni_proplist  myproplist;
	ni_property myproperty;
	ni_entrylist myentrylist;
	ni_id myid;
	ni_index myindex;
	char ps[10], str[256], domain[16], user[16], pages[QSIZE], *getpass();
	int i, j, use;
	int userp, domainp, usagep;

	userp = 0;
	usagep = 0;
	domainp = 0;
	
	for (i = 1; i < argc; i++) {
		if (argv[i][0] == '-') switch(argv[i][1]) {
			case 'd': strcpy(domain,argv[++i]); domainp = 1; break;
			case 'u': strcpy(user,argv[++i]); userp = 1; break;
			case 'p': strcpy(pages,argv[++i]); usagep = 1; break;
			default: usage(argv[0]);
		}
		else {
			if (userp == 0) {
				strcpy(user,argv[i]);
				userp = 1;
			}
			else {
				strcpy(pages,argv[i]);
				usagep = 1;
			}
		}
	}
	
	if (domainp == 0) strcpy(domain,DEFAULTDOMAIN);
	if (usagep == 0) strcpy(pages,"0");
	if (userp == 0) usage(argv[0]);

	/* open netinfo */
	rc = ni_open(NULL, domain, &myhandle);
	if (rc) errexit("ni_open",rc);
	
/*
	Horrible awful disgusting security hole. If your
	printer server is not the same machine as the
	NetInfo master, then you must supply the network
	root password in the following call.  If you want
	to hide this a bit better, try something like:

	ps[1]=56; ps[2]=97; ...
	rc = ni_setpassword(myhandle,ps);
	for(i=0;i<8;i++)ps[i]=0;

	This minimizes the amount of time that the raw
	password exists in a string that someone could
	read from the binary.  It is still ugly.
*/

	rc = ni_setpassword(myhandle,"ROOTWORD");
	if (rc) errexit("ni_setpassword",rc);
	rc = ni_setuser(myhandle,"root");
	if (rc) errexit("ni_setuser",rc);
	
	sprintf(str,"/users/%s",user);
	/* open the user's home directory */
	rc = ni_pathsearch(myhandle, &myid, str);
	if (rc) errexit("ni_pathsearch",rc);

	/* look up the PUPROP property */
	rc = ni_lookupprop(myhandle,&myid,PUPROP,&mynamelist);
	if (rc == NI_NOPROP) {
		use = 0;
		rc = 0;
	}
	else if (rc) errexit("ni_lookupprop",rc);
	else  {
		sscanf(mynamelist.ni_namelist_val[0],"%d",&use);
		sscanf(pages,"%d",&i);
		if (i < 0) exit(1);
		use = i + use;
		sprintf(pages,"%d",use);
		rc = ni_read(myhandle,&myid,&myproplist);
		if (rc) errexit("ni_read",rc);
		myindex = ni_proplist_match(myproplist,PUPROP,NULL);
		mynamelist.ni_namelist_len = 1;
		mynamelist.ni_namelist_val = malloc(sizeof(char *));
		mynamelist.ni_namelist_val[0] = malloc(QSIZE);
		strcpy(mynamelist.ni_namelist_val[0],pages);
		rc = ni_writeprop(myhandle,&myid,myindex,mynamelist);
		if (rc) errexit("ni_writeprop",rc);
	}
	
	ni_free(myhandle);
	exit(0);
}


errexit(s,rc)
char *s;
ni_status rc;
{
	fprintf(stderr,"%s: %s\n",s,ni_error(rc));
	exit(1);
}

usage(n)
char *n;
{
	fprintf(stderr,"usage: %s user pages\n",n);
	exit(1);
}
