#include <netinfo/ni.h>
#include <stdio.h>
#include "quota.h"

main(argc,argv)
int argc;
char *argv[];
{
	ni_status rc, ni_printdir();
	void *myhandle;
	ni_namelist mynamelist;
	ni_proplist  myproplist;
	ni_property myproperty;
	ni_entrylist myentrylist;
	ni_id myid;
	char str[256], user[16], domain[16];
	int i, j, q;
	int userp, domainp;

        userp = 0;
        domainp = 0;

        for (i = 1; i < argc; i++) {
                if (argv[i][0] == '-') switch(argv[i][1]) {
                        case 'd': strcpy(domain,argv[++i]); domainp = 1; break;
                        case 'u': strcpy(user,argv[++i]); userp = 1; break;
                        default: usage(argv[0]);
                }
                else {
                        strcpy(user,argv[i]);
                        userp = 1;
                }
        }

        if (domainp == 0) strcpy(domain,DEFAULTDOMAIN);
        if (userp == 0) usage(argv[0]);
	
	/* open netinfo */
	rc = ni_open(NULL, domain, &myhandle);
	if (rc) errexit("ni_open",rc);
	
	sprintf(str,"/users/%s",user);
	/* open the user's home directory */
	rc = ni_pathsearch(myhandle, &myid, str);
	if (rc) errexit("ni_pathsearch",rc);
	
	/* look up the PQPROP property */
	rc = ni_lookupprop(myhandle,&myid,PQPROP,&mynamelist);
	if (rc == NI_NOPROP) {
		q = 0;
		rc = 0;
	}
	else if (rc) errexit("ni_lookupprop",rc);
	else sscanf(mynamelist.ni_namelist_val[0],"%d",&q);
	printf("%d\n",q);
	
	ni_free(myhandle);
	exit(0);
}


errexit(s,rc)
char *s;
ni_status rc;
{
	fprintf(stderr,"%s: %s\n",s,ni_error(rc));
	exit(1);
}

usage(n)
char *n;
{
	fprintf(stderr,"usage: %s user\n",n);
	exit(1);
}
