.TH adsyn EMS
.SH NAME
adsyn.\fIm\fR \- file created by hetro(EMS) and used by Csound adsyn module for additive synthesis
.SH DESCRIPTION
.PP
The 
.I adsyn
unit generator in Csound provides a means of
synthesizing complex, time-varying timbres using the technique 
of additive synthesis.  
.I adsyn
works from a control file called
adsyn.m , where m is an integer (see Csound manual).  The  file
adsyn.m specifies the amplitude envelope and frequency path of
each partial that makes up an additive complex tone.  The 
information is in the form of breakpoints (time, value, time,
value, .....) using 16-bit integers.  Time is given in milliseconds,
amplitude values are given in the range of [0, +32767], and the
frequency is given in cps (Hertz).  Breakpoint data is exclusively
non-negative;  the value -1 in the control file marks the beginning
of an amplitude envelope and a -2 in the control file marks the
beginning of a frequency set.  A time value of 32767 followed by
a replication of the last desired amplitude or frequency value
is always included at the end of each envelope or set.
.PP
A partial is defined by a pair of sets: an envelope set
and a frequency set.  The sets may appear in any order but there
must be an equal number of amplitude and frequency sets in the
file.  For example, you may alternate amplitude and frequency sets,
list all amplitude sets first then all frequency sets, or do a few 
of one kind then a few of the other, but in the end there must be
the same total amount of each.  
.PP
There can be any number of breakpoints in each set but
.I adsyn
associates the first found amplitude set with the first
found frequency set, second with second, and so on.
.PP
The format of the adsyn.m is as follows:
.sp
.nf
.RS -.5i
        DATA                                      EXPLANATION
___________________________________________________________________________

-1 time1 value1 ......timeN valueN 32767 valueN  ; amplitude partial 1
                                                 ; breakpoints
-2 time1 value1 ......timeM valueM 32767 valueM  ; frequency partial 1
                                                 ; breakpoints

.............                                    ;any number of partials
                                                 ;in any ordering of
-1 time1 value1 ......                           ;amplitude and frequency
-2 time1 value1 ......                           ;but ordering of amplitude
-2 time1 value1 ......                           ;partials must be the same
-1 time1 value1 ......                           ;as ordering of frequency
                                                 ;partials.

.RE
.fi        
.PP
The Hetro program outputs to an adsyn.m file in this format but
alternates amplitude and frequency sets in increasing partial
order.
.SH FILES
adsyn.\fIm\fR
.SH "SEE ALSO"
hetro(EMS),
Csound(EMS),
.I "The Csound Reference Manual"
