/* Lpc analysis program, runs under cmix.  Doesn't really have to but
 * it was easy to work it up this way.  The only things that would have
 * to be replaced would be argument passing, and sample readins.
 * It is hard-wired right now to only write to a file called 'analysis'
 * There are a few settings in lpc.h which should be fussed with before
 * compiling.  They are used to set the maximum size of the arrays in 
 * alpol.c and gauss.c.  On a separate i/d machine these can probably
 * be expanded comfortably.  The lpcprofile sets the sampling rate and
 * defines the string lpcanal for data cards. (lpcprof.c).  A sample 
 * data file might be:
 *
 *     open 184 0  0          (opens ccss file 184, read only)
 *     lpcanal 9 10 18 125 1  (analyzes from time 9 to 10 on this file
 *			       with a frame size of 125, and starts 
 *                             writing output file at frame 1.) */
#include <stdio.h>
#include <math.h>
#include "../H/ugens.h"
int NPOLE;
int FRAME;
int NPP1;

lpcanal(p,n_args)
float *p;
{
	int jj,slice;
	float input[4],coef[36];
	double sig[500],errn,rms1,rms2,cc[40];
	long i,nsamps,outskip;
	int anal,ndata,nbytes,nblpc,iframe;
	if((anal = open("analysis",2)) < 0) {
		fprintf(stderr," Can't open data file\n");
		closesf();
		}
/* p0 is input skip, p1=dur, p2=npoles, p3=#new samps per frame,
 * p4 is output frame number (defaults to input)    */
	ndata = 4;   /* number of data values */
	NPOLE = p[2];
	FRAME = p[3] * 2;
	NPP1 = NPOLE+1;
	slice = FRAME/2;
	nblpc = (NPOLE + ndata)*FLOAT;
	if(!p[4]) p[4] = p[1] * SR/(float)slice;
	iframe = p[4];
	outskip = (long)(p[4]-1) * (long)nblpc;
	if((lseek(anal,outskip,0)) < 0) {
		fprintf(stderr,"Bad lseek on analysis file\n");
		closesf();
		}
	nsamps = setnot(p[0],p[1],0);
	for(i = 0; i<FRAME; i++) {
		getin(input,0);
		sig[i] = (double)input[0]; 
		}
	i = 0;
	while(i < nsamps) {

	alpol(sig,&errn,&rms1,&rms2,cc);
	coef[0] = (float)rms2;
	coef[1] = (float)rms1;
	coef[2] = (float)errn;
	printf("%d %f %f %f \n",iframe,coef[0],coef[1],coef[2]);
	coef[3] = 0.;  /*save for pitch of frame */
	for(jj=4; jj<NPOLE+4; jj++)
		coef[jj] = (float)-cc[NPOLE-jj+3];  
	for(jj=0; jj<slice; jj++,i++) {
		getin(input,0);
		sig[jj] = sig[jj+slice];
		sig[jj+slice] = (double)input[0];
		}
	if((nbytes = write(anal,(char *)coef,nblpc))!= nblpc) {
		printf(" write error, nbytes = %d\n",nbytes);
		closesf();
		}
	iframe++;
	}
}
