
c       factors real polynomial and finds roots
c       sigma coeff(i)*z**(i-1), i=1,k4
c       the coefficients are in ascending order, are not normalized
c       this version reads in eps, strips off leading zeros
      implicit double precision (a-h, o-z)
c       signal length<=1024
      double complex z(50)
      double precision y(50),rootr(49),rooti(49)
c       open a file for tty input
      open(1,file='/dev/tty')
      call input(k4,k5,z)
      k4m=k4-1
      write(0,1600)k4
1600  format('executing rootsre with k4= ',i4)
      do 1601 ii=1,k4
1601  y(ii)=z(ii)
c       find out if we want to suppress printing
      write(0,1667)
1667  format('type 0/return to suppress printing')
      read(1,1666)kk
1666  format(i1)
      kprint=1
      if(kk.eq.0)kprint=0
c     read in eps
      write(0,1668)
1668  format('type desired log-tolerance eps, format i4, eps=10.d0**')
      read(1,1669)ieps
1669  format(i4)
      eps=10.d0**(ieps)
      write(0,1670)eps
1670  format(' eps= ',d15.7)
306   if(y(1).ne.0.d0)goto303
      k4=k4-1
      do 304 i=1,k4
304   y(i)=y(i+1)
      write(0,305)k4
305   format('stripping off a leading zero, k4 now=',i4)
      goto306
303   call factor(y,k4,rootr,rooti,kinsid,kprint,eps)
      write(0,916)kinsid
916   format('there are',i5,'roots inside the unit circle')
      do 100 j=1,k4m
100   z(j)=dcmplx(rootr(j),rooti(j))
c       tack the highest degree coefficient onto the end
      z(k4)=z(k4)
      call output(k4,k5,z)
      stop 
      end

      subroutine factor(b,k4,rootr,rooti,kinsid,kprint,eps)
c       sets up problem, calls dproot, 
c       and checks residual values at roots  
      implicit double precision (a-h,o-z)
      double complex z,res,jay
      double precision b(1),rootr(1),rooti(1),coe(50)
      jay=(0.d0,1.d0)
      pi=4.d0*datan2(1.d0,1.d0)
      do 550 i=1,k4
550   coe(i)=b(i)
      k4m=k4-1
      call dproot(k4m,coe,rootr,rooti,kerr,kprint,eps)
      write(0,600)kerr
600   format(' return from dproot with kerr=',i5)
      if(kerr.gt.0)stop
      kinsid=0
      resmax=0.d0
      rmax=0.d0
      rmin=2.d0**(32)
      dist=2.d0**(32)
      amax=2.d0**(32)
      r2=amax**(1.d0/k4)
      do 701 j=1,k4m
      z=rootr(j)+jay*rooti(j)
      r=dsqrt(rootr(j)**2+rooti(j)**2)
c        skip residue calculation if root is too big
      if(r.gt.r2)goto713
      res=b(k4)
      do 705 k=2,k4
705   res=res*z+b(k4-k+1)
      partr=res
      parti=-jay*res
      resmag=dsqrt(partr**2+parti**2)
      if(resmax.le.resmag)resmax=resmag
713   if(rmax.lt.r)rmax=r
      if(rmin.gt.r)rmin=r
      if(r.lt.1.d0)kinsid=kinsid+1
      distr=dabs(r-1.d0)
      if(dist.gt.distr)dist=distr
701   continue
      write(0,703)resmax
      write(0,704)rmax,rmin,dist
703   format('resmax= ',d20.10)
704   format('rmax= ',d20.10/'rmin= ',d20.10/'dist=',d20.10)
      return
      end

      subroutine dproot(mm,a,rootr,rooti,kerr,kprint,eps)
c        mm=degree of polynomial
c        a=coefficient array, lowest to highest degree
c        kprint=1 for full printing
c        kerr=0 is normal return
      implicit double precision (a-h,o-z)
      double complex b(50),c(50),p,pp,z,w
      double complex bb(50),cc(50),jay
      double precision a(1),rootr(1),rooti(1)
      double precision save(50)
      jay=(0.d0,1.d0)
      mmp=mm+1
      m=mm
      mp=mmp
      do 700 i=1,mp
700   save(i)=a(i)
c       kount is number of iterations so far
      kount=0
c       kmax is maximum total number of iterations allowed
      kmax =20*m
c       newst is number of re-starts
      newst=0
c       ktrym is number of attempted iterations before re-starting
      ktrym=20
c       kpolm is number of attempted iterations before polishing is stopped
      kpolm=20
c       amax is the largest number we allow
      amax=2.d0**(32)
      amin=1.d0/amax
c       rr1 and rr2 are radii within which we work for polishing
      rr1=amin**(1.d0/m)
      rr2=amax**(1.d0/m)
c     eps is the tolerance for convergence
      sqteps=dsqrt(eps)
c        main loop; m is current degree
10    if(m.le.0)goto200
c        new z, a point on the unit circle
      rkount=kount
      z=dcos(rkount)+jay*dsin(rkount)
      ktry=0
c       r1 and r2 are boundaries of an expanding annulus within which we work
      r1=amin**(1.d0/m)
      r2=amax**(1.d0/m)
c        inside loop
20    partr=z
      parti=-jay*z
      size=dsqrt(partr**2+parti**2)
      if(size.lt.r1 .or. size.gt.r2)goto300
      if(ktry.ge.ktrym)goto300
      ktry=ktry+1
      if(kount.ge.kmax)goto400
      kount=kount+1
c        get value of polynomial at z, synthetic division
      b(mp)=a(mp)
      do 30 j=1,m
      k=m-j+1
30    b(k)=z*b(k+1)+a(k)
      p=b(1)
      partr=p
      parti=-jay*p
      if(dsqrt(partr**2+parti**2).gt.amax)goto300
c        get value of derivative at z, synthetic division
      c(mp)=b(mp)
      mdec=m-1
      do 60 j=1,mdec
      k=m-j+1
60    c(k)=z*c(k+1)+b(k)
      pp=c(2)
      partr=pp
      parti=-jay*pp
      if(dsqrt(partr**2+parti**2).lt.amin)goto300
c        test for convergence
      partr=p
      parti=-jay*p
      size=dsqrt(partr**2+parti**2)
      if(size.gt.eps)goto775
      nroot=mm-m+1
      if(kprint.eq.1)write(0,776)kount,nroot
776   format('kount=',i5,'  root no.=',i5)
      goto500
775   continue
      z=z-p/pp
      goto20
c        end of main loop

c        normal return
200   kerr=0
      goto600

c        new start
300   rkount=kount
      z=dcos(rkount)+jay*dsin(rkount)
      ktry=0
      newst=newst+1
      goto20

c        too many iterations
400   kerr=400
      goto600

c        root z located
c        polish z to get w
500   w=z
      kpol=0
510   partr=w
      parti=-jay*w
      size=dsqrt(partr**2+parti**2)
c       give up polishing if w is outside annulus
      if(size.lt.rr1 .or. size.gt.rr2)goto501
c       give up polishing if kpol>=kpolm
      if(kpol.ge.kpolm)goto501
      kpol=kpol+1
      if(kount.ge.kmax)goto400
      kount=kount+1
      bb(mmp)=save(mmp)
      do 530 j=1,mm
      k=mm-j+1
530   bb(k)=w*bb(k+1)+save(k)
      p=bb(1)
      partr=p
      parti=-jay*p
      if(dsqrt(partr**2+parti**2).gt.amax)goto300
      cc(mmp)=bb(mmp)
      mdec=mm-1
      do 560 j=1,mdec
      k=mm-j+1
560   cc(k)=w*cc(k+1)+bb(k)
      pp=cc(2)
      partr=pp
      parti=-jay*pp
      if(dsqrt(partr**2+parti**2).lt.amin)goto300
      partr=p
      parti=-jay*p
      size=dsqrt(partr**2+parti**2)
c       test for convergence of polishing
      if(size.le.eps)goto501
      w=w-p/pp
      goto510

c        deflate
501   b(mp)=a(mp)
      do 830 j=1,m
      k=m-j+1
830   b(k)=z*b(k+1)+a(k)
      p=b(1)
      rootr(m)=w
      rooti(m)=-jay*w
      m=m-1
      mp=mp-1
      parti=-jay*w
      if(dabs(parti).gt.sqteps)goto140
c        real root
      rooti(m+1)=0.d0
      do 100 j=1,mp
100   a(j)=b(j+1)
      goto10
c        complex root
140   partr=z
      parti=-jay*z
      z=partr-jay*parti
      c(mp)=b(mp+1)
      do 110 j=1,m
      k=m-j+1
110   c(k)=z*c(k+1)+b(k+1)
      rootr(m)=w
      rooti(m)=-(-jay*w)
      m=m-1
      mp=mp-1
      do 130 j=1,mp
130   a(j)=c(j+1)
      goto10
c        report and return
600   real1=kount
      real2=mm
      temp=real1/real2
      write(0,150)kount,temp
150   format(' kount=',i10,' kount/root=',f15.5)
      write(0,151)newst,kerr
151   format(' new starts=',i10,' kerr=',i10)
      return
      end

      subroutine input(nc,nd,y)
      double complex y(1)
      character z,z1
c       #      z1         number of complex points, nc and y
      data z1/'#'/
c       default options
      nc=1
      y(1)=(0.d0,0.d0)
10    read(5,1000,end=50)z
1000  format(a1)
      if(z.eq.z1)goto1
      goto10
1     read(5,1001)nc,nd
      read(5,1003)(y(ii),ii=1,nc)
      goto10
1001  format(2i4)
1003  format(2d20.10)
50    return
      end

      subroutine output (nc,nd,y)
      double complex y(1)
      write(6,1007)nc,nd,(y(ii),ii=1,nc)
1007  format('#'/2i4/(2d20.10))
      return
      end

