/*  Main program for pitch analysis
 *  This is a very BIG program and in order to run on the 34 it has
 *  to be broken down.  It requires
 *  1) A pipe using ccss' soundout with -O F option to force floating
 *     point output. The following command line would work, for example: 
 *
 * 			soundout -O F -d 1 sound | ptrack
 *
 *     The file should be mono.
 *  2) A regular ascii file called 'pchdata' and containing, on one or
 *     lines, the following information IN THIS ORDER
 *    -Name of file to contain analysis data--can be an old or null file.
 *    -Sampling rate.
 *    -LSLICE.  The total size of the frame to be analyzed, in samples.
 *     Maximum is 350, which has been good working number.  Frame should
 *     be able to contain at least one expected pitch period of signal.
 *    -JSLIDE.  The number of new samples to add per frame.  This number 
 *     should normally be less than half of LSLICE.  125 is good for 15k
 *     and 250 is good for 30k sampling rate.
 *     This number reflects the real time period of the frame, i.e. how
 *     far you creep up for each frame in the signal.
 *    -pchlow and pchigh-- expected lower and upper bounds of analysis.
 *     the better you guess at this, the better the quantization will
 *     be in the analysis.
 *     At the present time the highest fundamental analyzable is about SR/20
 *     cps, due to the settings of the lowpass filter.  This can be fixed
 *     by using interpolation, as in the fortran version of this program, 
 *     or, more sensibly, different filters.
 *    -inskip, amount of time to skip on input file before beginning analysis.
 *     The program is now written to write data sequentially beginning at the
 *     start of the data file, but this can be changed by simple adding an
 *     lseek.  
 *     (inskip should match the -s value in soundout).
 *    -dur,   amount of time to analyze. This should equal, but not
 *     exceed the -d value from soundout. 
 *  The following data file, is good for a 15k signal, for example:
 *
 *
 *      pitches 14000 350 125
 *	200 300
 *	0 .5
 *    
 */
 
#include <stdio.h>
#define FLOAT 4


int LSLICE;
int JSLIDE;
float SR;
float NYQ; 
int JMAX;
int MM;
main()

{

	float sig[350];
	int MIDPOINT,needed,howmuch;
	float tphi[50][5][18],tpsi[50][6][18];
	float tgamph[50][5],tgamps[50][6];
	float freq[50];
	float getpch(),getrms(),lowpass();
	float pchlow,pchigh,input[4];
	FILE *pdata;
	int i,n,jj,anal,framesize;
	long nsamps;
	float data[2],inskip,dur;
	char name[15];
	char *sigp,*sigtemp;
	double rmsm,freqm,rmsx,freqx;
	pdata = fopen("pchdata","r");
	fscanf(pdata,"%s",&name);
	fscanf(pdata,"%f",&SR);
	fscanf(pdata,"%d %d",&LSLICE,&JSLIDE);
	fscanf(pdata,"%f %f",&pchlow,&pchigh);
	fscanf(pdata,"%f %f",&inskip,&dur);
	NYQ = SR/2.;
	JMAX = LSLICE/10;
	MM = ((LSLICE/10+1)/2);
	fprintf(stderr,"Writing to file %s, sampling rate = %f\n",name,SR);
        fprintf(stderr,"Pitch boundaries = %f %f\n",pchlow,pchigh);
        fprintf(stderr,"Total samples per analyzed segment = %d\n",LSLICE);
        fprintf(stderr,"New samples per analyzed segment = %d\n",JSLIDE);
	if((anal = open(name,2)) < 0) {
		fprintf(stderr," cant open data file");
		exit(1);
		}

	MIDPOINT = LSLICE - JSLIDE;
	sigp = (char *)(sig+MIDPOINT);
	ptable(pchlow,pchigh,tphi,tpsi,tgamph,tgamps,freq,n);
	jj = read(0,(char *)sig,LSLICE*FLOAT);
	for(i=0; i<LSLICE; i++) sig[i]=lowpass(sig[i]);
	nsamps = SR * dur;
	while(nsamps) {
/*		data[0] = getpch(sig,tphi,tpsi,tgamph,tgamps,freq,n); */
		data[1] = getrms(sig);
		write(anal,(char *)data,8);  
		fprintf(stderr,"pitch= %f rmsamp= %f\n ",data[0],data[1]);
		for(i=0; i<MIDPOINT; i++)  sig[i] = sig[i+JSLIDE];
		howmuch=0;
		needed=JSLIDE*FLOAT;
		while(needed) { /* pipe doesn't always deliver full load*/
			howmuch = read(0,sigp+howmuch,needed);
		 	needed -= howmuch;
		}
		for(i=MIDPOINT; i<LSLICE; i++) sig[i] = lowpass(sig[i]); 
		nsamps -= JSLIDE; 
	}
}
