#include <stdio.h>
#include <fcntl.h>
#include "../../lp.h"
#define FLOAT 4

	int fd, nbytes, l, framsize, i, frmno = 0;
	char lpbuf[LPBUFSIZ];
	float frmbuf[MAXFRAME];
	LPHEADER *lph;
	
main(argc, argv)
int argc;
char *argv[];
{
	if ((fd = open(*++argv,O_RDONLY)) < 0)	{
		fprintf(stderr," lpdump: can't open %s\n",*argv);
		exit(1);
	}
	
	if ((nbytes = read(fd, lpbuf, LPBUFSIZ)) <= 0)	{
		fprintf(stderr," lpdump: read error on %s\n",*argv);
		exit(1);
	}
	
	lph = (LPHEADER *) lpbuf;
	if (lph->lpmagic != LP_MAGIC)	{
		fprintf(stderr, "lpdump: %s is not an lpfile\n",*argv);
		exit(1);
	}
	
	if ((l = lseek(fd, lph->headersize, 0)) < 0)	{
		fprintf(stderr, "lpdump: bad lseek on %s\n",*argv);
		exit(1);
	}
	
	framsize = lph->nvals * FLOAT;
	while (++frmno)	{
		if ((read(fd, (char *) frmbuf, framsize)) < framsize)	{
			printf("\nEnd of lp file\n");
			exit(0);
		}
		
		printf("\n\nFrame #%d\n",frmno);
		printf("Rms1: %f	Rms2: %f	Error: %f	Cps: %f\n",frmbuf[0], frmbuf[1], frmbuf[2], frmbuf[3]);
		printf("Coeffs:\n");
		for (i = 0; i < lph->npoles; i++)
			printf(" %f ",frmbuf[4 + i]);
	}
}
