#include <stdio.h>
#include <fcntl.h>
#include "../../lp.h"

	int n, fd;
	LPHEADER *lph;
	char lpbuf[LPBUFSIZ];

main(argc,argv)
int argc;
char *argv[];
{
	int i;

	if (argc < 2)      {
		 fprintf(stderr, "Usage: lpinfo f1 ...\n");
		 exit(1);
	}
	argc -= 1;
	for (i = 0; i < argc; i++)	{
		 printf("lp file: %s\n\n", *++argv);
		 if ((fd = open(*argv,O_RDONLY)) < 0)	{
			  fprintf(stderr,"Can't open file %s\n",*argv);
			  continue;
		 }
	
		 if ((n = read(fd, lpbuf, LPBUFSIZ * 2)) < 0)	{
			  fprintf(stderr,"%s: read error\n",*argv);
			  continue;
		 }

		 lph = (LPHEADER *) lpbuf;
		 if (lph->lpmagic != LP_MAGIC)	{
			  fprintf(stderr,"%s: not an lp file\n",*argv);
			  fprintf(stderr, "magic = %d, should be %d\n",
				  lph->lpmagic, LP_MAGIC);
			  continue;
		 }
	
		 printf("Number of poles : %d\n", lph->npoles);
		 printf("Values per frame : %d\n", lph->nvals);
		 printf("Headersize : %d bytes\n",lph->headersize);
		 printf("Frame rate : %f frames per second\n", lph->framrate);
		 printf("Sampling rate : %f samples per second\n", lph->srate);
		 printf("Duration : %f seconds\n", lph->duration);
		 prntfacts(lph);
	}
}

prntfacts(lph)
LPHEADER *lph;
{
	 int i;
	 char *cp;
	 
	 printf("Facts: \n");
	 cp = lph->text;
	 for (i = 0; i < (lph->headersize - (lph->text - (char *)lph)); i++) 
	   putchar(*cp++);
	 putchar('\n');
}

