.TH Csound EMS
.SH NAME
Csound \- audio processing and synthesis language
.SH DESCRIPTION
.PP
.I Csound
is a computationally efficient audio processing system with C-like syntax, in
which users can patch together arbitrarily complex signal processing networks
for realizing prescribed sound structures.
On-the-fly translation and dynamic allocation (load-and-go processing with no
compile step) provide fast interactive testing of experimental audio networks.
.PP
.I Csound
is invoked by a single
.I perf
command, which in turn invokes three phases of action:
.in +3
.I Score
sorting
.br
.I Orchestra
translation and loading
.br
.I Soundfile
generation via audio processing and synthesis routines.
.br
.in -3
The soundfile is then available for playback through the local
.I play
command.
.PP
.I Csound
audio processing is supported by various score languages,
score manipulation languages, a soundfile system, plus a set of
audio analysis programs such as linear predictive coding (LPC).
There is no complete on-line manual.  Most information is found in the
hard-copy
.I "Reference Manual,"
which provides an overview, tutorial, details of behavior,
and step-by-step examples.  Normal
.I man
entries do exist for the stand-alone audio analysis programs plus the
.I perf
command.
.SH "SEE ALSO"
adsyn(EMS), hetro(EMS), lpc(EMS), perf(EMS),
.I "The Csound Reference Manual"
.SH AUTHOR
.PP
Written by Barry Vercoe at the Experimental Music Studio of the
Media Laboratory at MIT.
